/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.storage;

import com.greatmancode.craftconomy3.Common;
import com.greatmancode.craftconomy3.storage.StorageEngine;
import com.greatmancode.craftconomy3.storage.sql.H2Engine;
import com.greatmancode.craftconomy3.storage.sql.MySQLEngine;

public class StorageHandler {
    private final StorageEngine engine;

    public StorageHandler() {
        switch (Common.getInstance().getMainConfig().getString("System.Database.Type")) {
            case "h2": {
                this.engine = new H2Engine();
                Common.getInstance().addMetricsGraph("Database Engine", "h2");
                break;
            }
            case "mysql": {
                this.engine = new MySQLEngine();
                Common.getInstance().addMetricsGraph("Database Engine", "MySQL");
                break;
            }
            default: {
                this.engine = null;
                Common.getInstance().getLogger().severe("Storage engine not supported!");
            }
        }
    }

    public StorageEngine getStorageEngine() {
        return this.engine;
    }

    public void disable() {
        this.engine.disable();
    }
}

