/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.currency;

import com.greatmancode.craftconomy3.Common;
import com.greatmancode.craftconomy3.utils.NoExchangeRate;

public class Currency {
    private String name;
    private String plural;
    private String minor;
    private String minorPlural;
    private String sign;
    private boolean status;
    private boolean bankCurrency;

    public Currency(String name, String plural, String minor, String minorPlural, String sign) {
        this(name, plural, minor, minorPlural, sign, false);
    }

    public Currency(String name, String plural, String minor, String minorPlural, String sign, boolean status) {
        this(name, plural, minor, minorPlural, sign, status, false);
    }

    public Currency(String name, String plural, String minor, String minorPlural, String sign, boolean status, boolean bankCurrency) {
        this.name = name;
        this.plural = plural;
        this.minor = minor;
        this.minorPlural = minorPlural;
        this.sign = sign;
        this.status = status;
        this.bankCurrency = bankCurrency;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldname = this.name;
        this.name = name;
        this.save(oldname);
    }

    public String getPlural() {
        return this.plural;
    }

    public void setPlural(String plural) {
        this.plural = plural;
        this.save();
    }

    public String getMinor() {
        return this.minor;
    }

    public void setMinor(String minor) {
        this.minor = minor;
        this.save();
    }

    public String getMinorPlural() {
        return this.minorPlural;
    }

    public void setMinorPlural(String minorPlural) {
        this.minorPlural = minorPlural;
        this.save();
    }

    public void setSign(String sign) {
        this.sign = sign;
        this.save();
    }

    public String getSign() {
        return this.sign;
    }

    public double getExchangeRate(Currency otherCurrency) throws NoExchangeRate {
        return Common.getInstance().getStorageHandler().getStorageEngine().getExchangeRate(this, otherCurrency);
    }

    public void setExchangeRate(Currency otherCurrency, double amount) {
        Common.getInstance().getStorageHandler().getStorageEngine().setExchangeRate(this, otherCurrency, amount);
    }

    private void save() {
        this.save(this.getName());
    }

    private void save(String oldName) {
        Common.getInstance().getStorageHandler().getStorageEngine().saveCurrency(oldName, this);
        Common.getInstance().getCurrencyManager().updateEntry(oldName, this);
    }

    void delete() {
        Common.getInstance().getStorageHandler().getStorageEngine().deleteCurrency(this);
    }

    protected void setDefault(boolean status) {
        this.status = status;
    }

    public boolean getStatus() {
        return this.status;
    }

    public boolean isPrimaryBankCurrency() {
        return this.bankCurrency;
    }

    protected void setBankCurrency(boolean bankCurrency) {
        this.bankCurrency = bankCurrency;
    }

    public String toString() {
        return "Currency{name='" + this.name + '\'' + ", plural='" + this.plural + '\'' + ", minor='" + this.minor + '\'' + ", minorPlural='" + this.minorPlural + '\'' + ", sign='" + this.sign + '\'' + ", status=" + this.status + ", bankCurrency=" + this.bankCurrency + '}';
    }
}

