/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.converter.converters;

import com.greatmancode.craftconomy3.Cause;
import com.greatmancode.craftconomy3.Common;
import com.greatmancode.craftconomy3.converter.Converter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class BoseEconomy
extends Converter {
    private static final String TAB_CHECK = "\\t+";
    private BufferedReader flatFileReader = null;
    private List<Converter.User> userList = new ArrayList<Converter.User>();

    public BoseEconomy() {
        this.getDbTypes().add("flatfile");
    }

    @Override
    public List<String> getDbInfo() {
        if (this.getDbInfoList().size() == 0) {
            this.getDbInfoList().add("filename");
        }
        return this.getDbInfoList();
    }

    @Override
    public boolean connect() {
        boolean result = false;
        File dbFile = new File(Common.getInstance().getServerCaller().getDataFolder(), this.getDbConnectInfo().get("filename"));
        if (dbFile.exists()) {
            try {
                this.flatFileReader = new BufferedReader(new FileReader(dbFile));
                result = true;
            }
            catch (FileNotFoundException e) {
                Common.getInstance().getLogger().severe("BoseEconomy database file not found!");
            }
        }
        return result;
    }

    @Override
    public boolean importData(String sender) {
        String line = "";
        try {
            int i = 0;
            while (line != null) {
                if (i % 10 == 0) {
                    Common.getInstance().getServerCaller().getPlayerCaller().sendMessage(sender, i + " {{DARK_GREEN}}accounts imported.");
                }
                if ((line = this.flatFileReader.readLine()) == null || !Pattern.compile("[?a-zA-Z0-9\\s{_-]+").matcher(line).matches()) continue;
                String username = line.split(" ")[0];
                line = this.flatFileReader.readLine();
                String type = line.split(" ")[1];
                if ("player".equalsIgnoreCase(type)) {
                    this.accountImporter(sender, username);
                    ++i;
                    continue;
                }
                if (!"type".equalsIgnoreCase(type)) continue;
                this.bankImporter(username);
                ++i;
            }
            this.flatFileReader.close();
            this.addAccountToString(sender, this.userList);
        }
        catch (IOException e) {
            Common.getInstance().getLogger().severe("Error while reading bose file!" + e.getMessage());
        }
        return true;
    }

    private void bankImporter(String username) throws IOException {
        String line = this.flatFileReader.readLine();
        double amount = Double.parseDouble(line.split(" ")[1]);
        Common.getInstance().getAccountManager().getAccount(username, true).set(amount, Common.getInstance().getServerCaller().getDefaultWorld(), Common.getInstance().getCurrencyManager().getDefaultCurrency().getName(), Cause.CONVERT, null);
        line = this.flatFileReader.readLine();
        if (line.contains("members")) {
            line = this.flatFileReader.readLine();
            line = line.replaceAll(TAB_CHECK, "");
            while (!"}".equals(line)) {
                Common.getInstance().getAccountManager().getAccount(username, true).getAccountACL().set(line, true, true, false, true, false);
                line = this.flatFileReader.readLine();
                line = line.replaceAll(TAB_CHECK, "");
            }
        }
        if ("owners".contains(line = this.flatFileReader.readLine())) {
            line = this.flatFileReader.readLine();
            line = line.replaceAll(TAB_CHECK, "");
            while (!"}".equals(line)) {
                Common.getInstance().getAccountManager().getAccount(username, true).getAccountACL().set(line, true, true, true, true, true);
                line = this.flatFileReader.readLine();
                line = line.replaceAll(TAB_CHECK, "");
            }
        }
    }

    private void accountImporter(String sender, String username) throws IOException {
        String line = this.flatFileReader.readLine();
        double amount = Double.parseDouble(line.split(" ")[1]);
        this.userList.add(new Converter.User(username, amount));
    }
}

