/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.commands.money;

import com.greatmancode.craftconomy3.Common;
import com.greatmancode.craftconomy3.account.Account;
import com.greatmancode.craftconomy3.commands.money.LogCommand;

class LogCommandThread
implements Runnable {
    private final String sender;
    private final int page;
    private final Account user;

    public LogCommandThread(String sender, int page, Account user) {
        this.sender = sender;
        this.page = page;
        this.user = user;
    }

    @Override
    public void run() {
        String ret = Common.getInstance().getLanguageManager().parse("money_log_header", this.page, this.user.getAccountName()) + "\n";
        for (LogCommand.LogEntry entry : Common.getInstance().getStorageHandler().getStorageEngine().getLog(this.user, this.page)) {
            ret = ret + "{{DARK_GREEN}}Time: {{WHITE}}" + entry.timestamp + " {{DARK_GREEN}}Type: {{WHITE}}" + entry.type + " {{DARK_GREEN}} Amount: {{WHITE}}" + Common.getInstance().format(entry.worldName, entry.currency, entry.amount) + " {{DARK_GREEN}}Cause: {{WHITE}}" + entry.cause;
            if (entry.causeReason != null) {
                ret = ret + " {{DARK_GREEN}}Reason: {{WHITE}}" + entry.causeReason;
            }
            ret = ret + "\n";
        }
        Common.getInstance().getServerCaller().getSchedulerCaller().delay(new TopCommandThreadEnd(this.sender, ret), 0L, false);
    }

    class TopCommandThreadEnd
    implements Runnable {
        private final String sender;
        private final String ret;

        public TopCommandThreadEnd(String sender, String ret) {
            this.sender = sender;
            this.ret = ret;
        }

        @Override
        public void run() {
            Common.getInstance().getServerCaller().getPlayerCaller().sendMessage(this.sender, this.ret);
        }
    }
}

