/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.commands.currency;

import com.greatmancode.craftconomy3.Common;
import com.greatmancode.craftconomy3.currency.Currency;
import com.greatmancode.craftconomy3.tools.commands.interfaces.CommandExecutor;

public class CurrencyRatesCommand
extends CommandExecutor {
    @Override
    public void execute(String sender, String[] args) {
        Common.getInstance().getServerCaller().getPlayerCaller().sendMessage(sender, Common.getInstance().getLanguageManager().getString("rates_header"));
        for (CurrencyRateEntry entry : Common.getInstance().getStorageHandler().getStorageEngine().getCurrencyExchanges()) {
            Common.getInstance().getServerCaller().getPlayerCaller().sendMessage(sender, "1 " + entry.from.getName() + " => " + entry.amount + " " + entry.to.getName());
        }
    }

    @Override
    public String help() {
        return Common.getInstance().getLanguageManager().getString("currency_rates_cmd_help");
    }

    @Override
    public int maxArgs() {
        return 0;
    }

    @Override
    public int minArgs() {
        return 0;
    }

    @Override
    public boolean playerOnly() {
        return false;
    }

    @Override
    public String getPermissionNode() {
        return "craftconomy.rates";
    }

    public static class CurrencyRateEntry {
        private double amount;
        private Currency from;
        private Currency to;

        public CurrencyRateEntry(Currency from, Currency to, double amount) {
            this.amount = amount;
            this.from = from;
            this.to = to;
        }

        public double getAmount() {
            return this.amount;
        }

        public Currency getFrom() {
            return this.from;
        }

        public Currency getTo() {
            return this.to;
        }
    }
}

