/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.account;

import com.greatmancode.craftconomy3.Common;
import com.greatmancode.craftconomy3.account.Account;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AccountManager {
    private final Map<String, Account> accountList = new HashMap<String, Account>();
    private final Map<String, Account> bankList = new HashMap<String, Account>();

    public Account getAccount(String name, boolean bankAccount) {
        Account account;
        String newName = name;
        if (!Common.getInstance().getMainConfig().getBoolean("System.Case-sentitive")) {
            newName = name.toLowerCase();
        }
        if (bankAccount && this.bankList.containsKey(newName)) {
            account = this.bankList.get(newName);
        } else if (!bankAccount && this.accountList.containsKey(newName)) {
            account = this.accountList.get(newName);
        } else {
            account = Common.getInstance().getStorageHandler().getStorageEngine().getAccount(newName, bankAccount);
            if (bankAccount) {
                this.bankList.put(newName, account);
            } else {
                this.accountList.put(newName, account);
            }
        }
        return account;
    }

    @Deprecated
    public Account getAccount(String name) {
        if (name.startsWith("bank:")) {
            return this.getAccount(name.split("bank:")[1], true);
        }
        return this.getAccount(name, false);
    }

    public boolean exist(String name, boolean bankAccount) {
        boolean result;
        String newName = name;
        if (!Common.getInstance().getMainConfig().getBoolean("System.Case-sentitive")) {
            newName = name.toLowerCase();
        }
        if (bankAccount) {
            result = this.bankList.containsKey(newName);
            if (!result) {
                result = Common.getInstance().getStorageHandler().getStorageEngine().accountExist(newName, bankAccount);
            }
        } else {
            result = this.accountList.containsKey(newName);
            if (!result) {
                result = Common.getInstance().getStorageHandler().getStorageEngine().accountExist(newName, bankAccount);
            }
        }
        return result;
    }

    @Deprecated
    public boolean exist(String name) {
        if (name.startsWith("bank:")) {
            return this.exist(name.split("bank:")[1], true);
        }
        return this.exist(name, false);
    }

    public boolean delete(String name, boolean bankAccount) {
        boolean result = false;
        if (this.exist(name, bankAccount)) {
            result = Common.getInstance().getStorageHandler().getStorageEngine().deleteAccount(name, bankAccount);
            if (bankAccount) {
                this.bankList.remove(name);
            } else {
                this.accountList.remove(name);
            }
        }
        return result;
    }

    public void clearCache(String name) {
        this.accountList.remove(name);
    }

    public List<String> getAllAccounts(boolean bank) {
        return Common.getInstance().getStorageHandler().getStorageEngine().getAllAccounts(bank);
    }
}

