/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.account;

import com.greatmancode.craftconomy3.Common;
import com.greatmancode.craftconomy3.account.Account;
import com.greatmancode.craftconomy3.account.AccountACLValue;
import java.util.Map;

public class AccountACL {
    private final Map<String, AccountACLValue> aclList;
    private final Account account;

    public AccountACL(Account account) {
        this.account = account;
        this.aclList = Common.getInstance().getStorageHandler().getStorageEngine().retrieveACL(account);
    }

    public boolean canDeposit(String name) {
        if (this.getParent().ignoreACL()) {
            return true;
        }
        String newName = name.toLowerCase();
        boolean result = false;
        if (this.aclList.containsKey(newName)) {
            result = this.aclList.get(newName).canDeposit();
        }
        return result;
    }

    public boolean canWithdraw(String name) {
        if (this.getParent().ignoreACL()) {
            return true;
        }
        String newName = name.toLowerCase();
        boolean result = false;
        if (this.aclList.containsKey(newName)) {
            result = this.aclList.get(newName).canWithdraw();
        }
        return result;
    }

    public boolean canAcl(String name) {
        if (this.getParent().ignoreACL()) {
            return false;
        }
        String newName = name.toLowerCase();
        boolean result = false;
        if (this.aclList.containsKey(newName)) {
            result = this.aclList.get(newName).canAcl();
        }
        return result;
    }

    public boolean canShow(String name) {
        if (this.getParent().ignoreACL()) {
            return true;
        }
        String newName = name.toLowerCase();
        boolean result = false;
        if (this.aclList.containsKey(newName)) {
            result = this.aclList.get(newName).canBalance();
        }
        return result;
    }

    public void setDeposit(String name, boolean deposit) {
        String newName = name.toLowerCase();
        if (this.aclList.containsKey(newName)) {
            AccountACLValue value = this.aclList.get(newName);
            this.set(newName, deposit, value.canWithdraw(), value.canAcl(), value.canBalance(), value.isOwner());
        } else {
            this.set(newName, deposit, false, false, false, false);
        }
    }

    public void setWithdraw(String name, boolean withdraw) {
        String newName = name.toLowerCase();
        if (this.aclList.containsKey(name)) {
            AccountACLValue value = this.aclList.get(newName);
            this.set(newName, value.canDeposit(), withdraw, value.canAcl(), value.canBalance(), value.isOwner());
        } else {
            this.set(newName, false, withdraw, false, false, false);
        }
    }

    public void setAcl(String name, boolean acl) {
        String newName = name.toLowerCase();
        if (this.aclList.containsKey(newName)) {
            AccountACLValue value = this.aclList.get(newName);
            this.set(newName, value.canDeposit(), value.canWithdraw(), acl, value.canBalance(), value.isOwner());
        } else {
            this.set(newName, false, false, acl, false, false);
        }
    }

    public void setShow(String name, boolean show) {
        String newName = name.toLowerCase();
        if (this.aclList.containsKey(newName)) {
            AccountACLValue value = this.aclList.get(newName);
            this.set(newName, value.canDeposit(), value.canWithdraw(), value.canAcl(), show, value.isOwner());
        } else {
            this.set(newName, false, false, false, show, false);
        }
    }

    public void set(String name, boolean deposit, boolean withdraw, boolean acl, boolean show, boolean owner) {
        String newName = name.toLowerCase();
        this.aclList.put(name, Common.getInstance().getStorageHandler().getStorageEngine().saveACL(this.account, newName, deposit, withdraw, acl, show, owner));
    }

    public boolean isOwner(String name) {
        boolean result = false;
        if (this.aclList.containsKey(name)) {
            result = this.aclList.get(name).isOwner();
        }
        return result;
    }

    public Account getParent() {
        return this.account;
    }
}

