/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.com.zaxxer.hikari.util;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;

public final class DriverDataSource
implements DataSource {
    private final String jdbcUrl;
    private final Properties driverProperties;
    private PrintWriter logWriter;

    public DriverDataSource(String jdbcUrl, Properties properties, String username, String password) {
        try {
            this.jdbcUrl = jdbcUrl;
            this.driverProperties = new Properties(properties);
            if (username != null) {
                this.driverProperties.put("user", this.driverProperties.getProperty("user", username));
            }
            if (password != null) {
                this.driverProperties.put("password", this.driverProperties.getProperty("password", password));
            }
            if (DriverManager.getDriver(jdbcUrl) == null) {
                throw new IllegalArgumentException("DriverManager was unable to load driver for URL " + jdbcUrl);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to get driver for JDBC URL " + jdbcUrl);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.jdbcUrl, this.driverProperties);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) throws SQLException {
        this.logWriter = logWriter;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        DriverManager.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    public void shutdown() {
    }
}

