/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.com.zaxxer.hikari.util;

import com.greatmancode.com.zaxxer.hikari.util.FastList;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedLongSynchronizer;

public class ConcurrentBag<T extends IBagManagable> {
    public static final int STATE_NOT_IN_USE = 0;
    public static final int STATE_IN_USE = 1;
    private static final int STATE_REMOVED = -1;
    private static final int STATE_RESERVED = -2;
    private ThreadLocal<FastList<WeakReference<T>>> threadList;
    private CopyOnWriteArraySet<T> sharedList = new CopyOnWriteArraySet();
    private Synchronizer synchronizer = new Synchronizer();
    private IBagStateListener listener;

    public ConcurrentBag() {
        this.threadList = new ThreadLocal();
    }

    public T borrow(long timeout, TimeUnit timeUnit) throws InterruptedException {
        long startScan;
        FastList<WeakReference<T>> list = this.threadList.get();
        if (list == null) {
            list = new FastList(WeakReference.class);
            this.threadList.set(list);
        } else {
            for (int i = list.size() - 1; i >= 0; --i) {
                WeakReference<T> reference = list.removeLast();
                IBagManagable element = (IBagManagable)reference.get();
                if (element == null || !element.compareAndSetState(0, 1)) continue;
                return (T)element;
            }
        }
        timeout = timeUnit.toNanos(timeout);
        do {
            startScan = System.nanoTime();
            for (IBagManagable reference : this.sharedList) {
                if (!reference.compareAndSetState(0, 1)) continue;
                return (T)reference;
            }
            if (this.listener != null) {
                this.listener.addBagItem();
            }
            this.synchronizer.tryAcquireSharedNanos(startScan, timeout);
        } while ((timeout -= System.nanoTime() - startScan) > 0L);
        return null;
    }

    public void requite(T value) {
        FastList<WeakReference<WeakReference<T>>> list;
        if (value == null) {
            throw new NullPointerException("Cannot return a null value to the bag");
        }
        if (value.compareAndSetState(1, 0)) {
            list = this.threadList.get();
            if (list == null) {
                list = new FastList(WeakReference.class);
                this.threadList.set(list);
            }
        } else {
            throw new IllegalStateException("Value was returned to the bag that was not borrowed: " + value);
        }
        list.add(new WeakReference<T>(value));
        this.synchronizer.releaseShared(System.nanoTime());
    }

    public void add(T value) {
        long addTime = System.nanoTime();
        this.sharedList.add(value);
        this.synchronizer.releaseShared(addTime);
    }

    public void remove(T value) {
        if (value.compareAndSetState(1, -1) || value.compareAndSetState(-2, -1)) {
            if (!this.sharedList.remove(value)) {
                throw new IllegalStateException("Attempt to remove an object from the bag that does not exist");
            }
        } else {
            throw new IllegalStateException("Attempt to remove an object from the bag that was not borrowed or reserved");
        }
    }

    public List<T> values(int state) {
        ArrayList<IBagManagable> list = new ArrayList<IBagManagable>(this.sharedList.size());
        if (state == 1 || state == 0) {
            for (IBagManagable reference : this.sharedList) {
                if (reference.getState() != state) continue;
                list.add(reference);
            }
        }
        return list;
    }

    public boolean reserve(T value) {
        return value.compareAndSetState(0, -2);
    }

    public void unreserve(T value) {
        long checkInTime = System.nanoTime();
        if (!value.compareAndSetState(-2, 0)) {
            throw new IllegalStateException("Attempt to relinquish an object to the bag that was not reserved");
        }
        this.synchronizer.releaseShared(checkInTime);
    }

    public void addBagStateListener(IBagStateListener listener) {
        this.listener = listener;
    }

    public int getPendingQueue() {
        return this.synchronizer.getQueueLength();
    }

    public int getCount(int state) {
        int count = 0;
        for (IBagManagable reference : this.sharedList) {
            if (reference.getState() != state) continue;
            ++count;
        }
        return count;
    }

    public int size() {
        return this.sharedList.size();
    }

    private static class Synchronizer
    extends AbstractQueuedLongSynchronizer {
        private static final long serialVersionUID = 104753538004341218L;
        private static final boolean JAVA7;

        private Synchronizer() {
        }

        @Override
        protected long tryAcquireShared(long startScanTime) {
            return this.getState() >= startScanTime && !this.java67hasQueuedPredecessors() ? 1L : -1L;
        }

        @Override
        protected boolean tryReleaseShared(long updateTime) {
            this.setState(updateTime);
            return true;
        }

        private boolean java67hasQueuedPredecessors() {
            if (JAVA7) {
                return this.hasQueuedPredecessors();
            }
            return false;
        }

        static {
            boolean b = false;
            try {
                b = AbstractQueuedLongSynchronizer.class.getMethod("hasQueuedPredecessors", new Class[0]) != null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            JAVA7 = b;
        }
    }

    public static interface IBagStateListener {
        public void addBagItem();
    }

    public static interface IBagManagable {
        public int getState();

        public boolean compareAndSetState(int var1, int var2);
    }
}

