/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.com.zaxxer.hikari.pool;

import com.greatmancode.com.zaxxer.hikari.HikariConfig;
import com.greatmancode.com.zaxxer.hikari.pool.HikariPool;
import com.greatmancode.org.slf4j.Logger;
import com.greatmancode.org.slf4j.LoggerFactory;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class HikariMBeanElf {
    private static final Logger LOGGER = LoggerFactory.getLogger(HikariMBeanElf.class);

    private HikariMBeanElf() {
    }

    public static void registerMBeans(HikariConfig configuration, HikariPool pool) {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName poolConfigName = new ObjectName("com.greatmancode.com.zaxxer.hikari:type=PoolConfig (" + configuration.getPoolName() + ")");
            ObjectName poolName = new ObjectName("com.greatmancode.com.zaxxer.hikari:type=Pool (" + configuration.getPoolName() + ")");
            if (!mBeanServer.isRegistered(poolConfigName)) {
                mBeanServer.registerMBean(configuration, poolConfigName);
                mBeanServer.registerMBean(pool, poolName);
            } else {
                LOGGER.error("You cannot use the same HikariConfig for separate pool instances.");
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unable to register management beans.", e);
        }
    }

    public static void unregisterMBeans(HikariConfig configuration, HikariPool pool) {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName poolConfigName = new ObjectName("com.greatmancode.com.zaxxer.hikari:type=PoolConfig (" + configuration.getPoolName() + ")");
            ObjectName poolName = new ObjectName("com.greatmancode.com.zaxxer.hikari:type=Pool (" + configuration.getPoolName() + ")");
            if (mBeanServer.isRegistered(poolConfigName)) {
                mBeanServer.unregisterMBean(poolConfigName);
                mBeanServer.unregisterMBean(poolName);
            } else {
                LOGGER.error("No registered MBean for {}.", (Object)configuration.getPoolName());
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unable to unregister management beans.", e);
        }
    }
}

