/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.com.zaxxer.hikari;

import com.greatmancode.com.zaxxer.hikari.HikariConfig;
import com.greatmancode.com.zaxxer.hikari.HikariDataSource;
import com.greatmancode.com.zaxxer.hikari.util.PropertyBeanSetter;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;

public class HikariJNDIFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (obj == null || !(obj instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)obj;
        if (!"javax.sql.DataSource".equals(ref.getClassName())) {
            throw new NamingException(ref.getClassName() + " is not a valid class name/type for this JNDI factory.");
        }
        Properties properties = new Properties();
        for (String propertyName : PropertyBeanSetter.getPropertyNames(HikariConfig.class)) {
            RefAddr ra = ref.get(propertyName);
            if (ra == null) continue;
            String propertyValue = ra.getContent().toString();
            properties.setProperty(propertyName, propertyValue);
        }
        return this.createDataSource(properties, nameCtx);
    }

    private DataSource createDataSource(Properties properties, Context context) {
        if (properties.getProperty("dataSourceJNDI") != null) {
            return this.lookupJndiDataSource(properties, context);
        }
        return new HikariDataSource(new HikariConfig(properties));
    }

    private DataSource lookupJndiDataSource(Properties properties, Context context) {
        DataSource jndiDS = null;
        String jndiName = properties.getProperty("dataSourceJNDI");
        try {
            if (context == null) {
                throw new RuntimeException("dataSourceJNDI property is configued, but local JNDI context is null.");
            }
            jndiDS = (DataSource)context.lookup(jndiName);
        }
        catch (NamingException e) {
            throw new RuntimeException("The name \"" + jndiName + "\" can not be found in the local context.");
        }
        if (jndiDS == null) {
            try {
                context = new InitialContext();
                jndiDS = (DataSource)context.lookup(jndiName);
            }
            catch (NamingException e) {
                throw new RuntimeException("The name \"" + jndiName + "\" can not be found in the InitialContext.");
            }
        }
        if (jndiDS != null) {
            HikariConfig config = new HikariConfig(properties);
            config.setDataSource(jndiDS);
            return new HikariDataSource(config);
        }
        return null;
    }
}

