/*
 * Decompiled with CFR 0.152.
 */
package org.dataloader.reactive;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.dataloader.impl.DataLoaderAssertionException;
import org.dataloader.reactive.AbstractBatchSubscriber;
import org.dataloader.reactive.ReactiveSupport;

class BatchSubscriberImpl<K, V>
extends AbstractBatchSubscriber<K, V, V> {
    private int idx = 0;

    BatchSubscriberImpl(CompletableFuture<List<V>> valuesFuture, List<K> keys, List<Object> callContexts, List<CompletableFuture<V>> queuedFutures, ReactiveSupport.HelperIntegration<K> helperIntegration) {
        super(valuesFuture, keys, callContexts, queuedFutures, helperIntegration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(V value) {
        try {
            this.lock.lock();
            super.onNext(value);
            if (this.idx >= this.keys.size()) {
                return;
            }
            Object key = this.keys.get(this.idx);
            Object callContext = this.callContexts.get(this.idx);
            CompletableFuture future = (CompletableFuture)this.queuedFutures.get(this.idx);
            this.onNextValue(key, value, callContext, List.of(future));
            this.completedValues.add(value);
            ++this.idx;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void onComplete() {
        try {
            this.lock.lock();
            super.onComplete();
            if (this.keys.size() != this.completedValues.size()) {
                for (CompletableFuture queuedFuture : this.queuedFutures) {
                    if (queuedFuture.isDone()) continue;
                    queuedFuture.completeExceptionally(new DataLoaderAssertionException("The size of the promised values MUST be the same size as the key list"));
                }
            }
            this.possiblyClearCacheEntriesOnExceptions();
            this.valuesFuture.complete(this.completedValues);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable ex) {
        try {
            this.lock.lock();
            super.onError(ex);
            ex = this.unwrapThrowable(ex);
            for (int i = this.idx; i < this.queuedFutures.size(); ++i) {
                Object key = this.keys.get(i);
                CompletableFuture future = (CompletableFuture)this.queuedFutures.get(i);
                if (future.isDone()) continue;
                future.completeExceptionally(ex);
                this.helperIntegration.clearCacheView(key);
            }
            this.valuesFuture.completeExceptionally(ex);
        }
        finally {
            this.lock.unlock();
        }
    }
}

