/*
 * Decompiled with CFR 0.152.
 */
package org.dataloader;

import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.dataloader.PublicApi;
import org.dataloader.impl.Assertions;

@PublicApi
public class Try<V> {
    private static Throwable NIL = new Throwable(){

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    };
    private final Throwable throwable;
    private final V value;

    private Try(Throwable throwable) {
        this.throwable = Assertions.nonNull(throwable);
        this.value = NIL;
    }

    private Try(V value) {
        this.value = value;
        this.throwable = null;
    }

    public static <V> Try<V> succeeded(V value) {
        return new Try<V>(value);
    }

    public static <V> Try<V> failed(Throwable throwable) {
        return new Try<V>(throwable);
    }

    public static <V> Try<V> tryCall(Callable<V> callable) {
        try {
            return Try.succeeded(callable.call());
        }
        catch (Exception e) {
            return Try.failed(e);
        }
    }

    public static <V> CompletionStage<Try<V>> tryStage(CompletionStage<V> completionStage) {
        return completionStage.handle((value, throwable) -> {
            if (throwable != null) {
                return Try.failed(throwable);
            }
            return Try.succeeded(value);
        });
    }

    public V get() {
        if (this.isFailure()) {
            throw new UnsupportedOperationException("You have called Try.get() with a failed Try", this.throwable);
        }
        return this.value;
    }

    public Throwable getThrowable() {
        if (this.isSuccess()) {
            throw new UnsupportedOperationException("You have called Try.getThrowable() with a failed Try", this.throwable);
        }
        return this.throwable;
    }

    public boolean isSuccess() {
        return this.value != NIL;
    }

    public boolean isFailure() {
        return this.value == NIL;
    }

    public <U> Try<U> map(Function<? super V, U> mapper) {
        if (this.isSuccess()) {
            return Try.succeeded(mapper.apply(this.value));
        }
        return Try.failed(this.throwable);
    }

    public <U> Try<U> flatMap(Function<? super V, Try<U>> mapper) {
        if (this.isSuccess()) {
            return mapper.apply(this.value);
        }
        return Try.failed(this.throwable);
    }

    public Optional<V> toOptional() {
        return this.isSuccess() ? Optional.ofNullable(this.value) : Optional.empty();
    }

    public V orElse(V other) {
        return this.isSuccess() ? this.value : other;
    }

    public V orElseGet(Supplier<V> otherSupplier) {
        return this.isSuccess() ? this.value : otherSupplier.get();
    }

    public void reThrow() throws Throwable {
        if (this.isSuccess()) {
            throw new UnsupportedOperationException("You have called Try.reThrow() with a successful Try.  There is nothing to rethrow");
        }
        throw this.throwable;
    }

    void forEach(Consumer<? super V> action) {
        if (this.isSuccess()) {
            action.accept(this.value);
        }
    }

    public Try<V> recover(Function<Throwable, V> recoverFunction) {
        if (this.isFailure()) {
            return Try.succeeded(recoverFunction.apply(this.throwable));
        }
        return this;
    }
}

