/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalars.numeric;

import graphql.Internal;
import graphql.scalars.numeric.FloatCoercing;
import graphql.schema.Coercing;
import graphql.schema.GraphQLScalarType;
import java.util.function.Function;

@Internal
public class NonNegativeFloatScalar
extends GraphQLScalarType {
    public NonNegativeFloatScalar() {
        super("NonNegativeFloat", "An Float scalar that must be greater than or equal to zero", (Coercing)new FloatCoercing(){

            @Override
            protected Double check(Double d, Function<String, RuntimeException> exceptionMaker) {
                if (!(d >= 0.0)) {
                    throw exceptionMaker.apply("The value must be greater than or equal to zero");
                }
                return d;
            }
        });
    }
}

