/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalars.numeric;

import graphql.Internal;
import graphql.scalars.numeric.FloatCoercing;
import graphql.schema.Coercing;
import graphql.schema.GraphQLScalarType;
import java.util.function.Function;

@Internal
public class PositiveFloatScalar
extends GraphQLScalarType {
    public PositiveFloatScalar() {
        super("PositiveFloat", "An Float scalar that must be a positive value", (Coercing)new FloatCoercing(){

            @Override
            protected Double check(Double d, Function<String, RuntimeException> exceptionMaker) {
                if (!(d > 0.0)) {
                    throw exceptionMaker.apply("The value must be a positive value");
                }
                return d;
            }
        });
    }
}

