/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations;

import graphql.annotations.GraphQLInvokeDetached;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

class MethodDataFetcher
implements DataFetcher {
    private final Method method;
    private final int envIndex;

    public MethodDataFetcher(Method method) {
        this.method = method;
        List parameterTypes = Arrays.asList(method.getParameters()).stream().map(Parameter::getType).collect(Collectors.toList());
        this.envIndex = parameterTypes.indexOf(DataFetchingEnvironment.class);
    }

    public Object get(DataFetchingEnvironment environment) {
        try {
            Object obj;
            if (Modifier.isStatic(this.method.getModifiers())) {
                obj = null;
            } else if (this.method.getAnnotation(GraphQLInvokeDetached.class) == null) {
                obj = environment.getSource();
                if (obj == null) {
                    return null;
                }
            } else {
                obj = this.method.getDeclaringClass().newInstance();
            }
            ArrayList args = new ArrayList(environment.getArguments().values());
            if (this.envIndex >= 0) {
                args.add(this.envIndex, environment);
            }
            return this.method.invoke(obj, args.toArray());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

