/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.autoconfigure.editor.altair;

import graphql.kickstart.autoconfigure.editor.altair.AltairOptions;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StreamUtils;

@ConfigurationProperties(value="graphql.altair.resources")
public class AltairResources {
    private String initialQuery;
    private String initialVariables;
    private String initialPreRequestScript;
    private String initialPostRequestScript;

    public void load(AltairOptions options) {
        this.loadResource(this.initialQuery).ifPresent(options::setInitialQuery);
        this.loadResource(this.initialVariables).ifPresent(options::setInitialVariables);
        this.loadResource(this.initialPreRequestScript).ifPresent(options::setInitialPreRequestScript);
        this.loadResource(this.initialPostRequestScript).ifPresent(options::setInitialPostRequestScript);
    }

    private Optional<String> loadResource(String property) {
        return Optional.ofNullable(property).map(ClassPathResource::new).map(this::loadResource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadResource(Resource resource) {
        try (InputStream inputStream = resource.getInputStream();){
            String string = StreamUtils.copyToString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    @Generated
    public AltairResources() {
    }

    @Generated
    public String getInitialQuery() {
        return this.initialQuery;
    }

    @Generated
    public String getInitialVariables() {
        return this.initialVariables;
    }

    @Generated
    public String getInitialPreRequestScript() {
        return this.initialPreRequestScript;
    }

    @Generated
    public String getInitialPostRequestScript() {
        return this.initialPostRequestScript;
    }

    @Generated
    public void setInitialQuery(String initialQuery) {
        this.initialQuery = initialQuery;
    }

    @Generated
    public void setInitialVariables(String initialVariables) {
        this.initialVariables = initialVariables;
    }

    @Generated
    public void setInitialPreRequestScript(String initialPreRequestScript) {
        this.initialPreRequestScript = initialPreRequestScript;
    }

    @Generated
    public void setInitialPostRequestScript(String initialPostRequestScript) {
        this.initialPostRequestScript = initialPostRequestScript;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AltairResources)) {
            return false;
        }
        AltairResources other = (AltairResources)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$initialQuery = this.getInitialQuery();
        String other$initialQuery = other.getInitialQuery();
        if (this$initialQuery == null ? other$initialQuery != null : !this$initialQuery.equals(other$initialQuery)) {
            return false;
        }
        String this$initialVariables = this.getInitialVariables();
        String other$initialVariables = other.getInitialVariables();
        if (this$initialVariables == null ? other$initialVariables != null : !this$initialVariables.equals(other$initialVariables)) {
            return false;
        }
        String this$initialPreRequestScript = this.getInitialPreRequestScript();
        String other$initialPreRequestScript = other.getInitialPreRequestScript();
        if (this$initialPreRequestScript == null ? other$initialPreRequestScript != null : !this$initialPreRequestScript.equals(other$initialPreRequestScript)) {
            return false;
        }
        String this$initialPostRequestScript = this.getInitialPostRequestScript();
        String other$initialPostRequestScript = other.getInitialPostRequestScript();
        return !(this$initialPostRequestScript == null ? other$initialPostRequestScript != null : !this$initialPostRequestScript.equals(other$initialPostRequestScript));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AltairResources;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $initialQuery = this.getInitialQuery();
        result = result * 59 + ($initialQuery == null ? 43 : $initialQuery.hashCode());
        String $initialVariables = this.getInitialVariables();
        result = result * 59 + ($initialVariables == null ? 43 : $initialVariables.hashCode());
        String $initialPreRequestScript = this.getInitialPreRequestScript();
        result = result * 59 + ($initialPreRequestScript == null ? 43 : $initialPreRequestScript.hashCode());
        String $initialPostRequestScript = this.getInitialPostRequestScript();
        result = result * 59 + ($initialPostRequestScript == null ? 43 : $initialPostRequestScript.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AltairResources(initialQuery=" + this.getInitialQuery() + ", initialVariables=" + this.getInitialVariables() + ", initialPreRequestScript=" + this.getInitialPreRequestScript() + ", initialPostRequestScript=" + this.getInitialPostRequestScript() + ")";
    }
}

