/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.autoconfigure.editor;

import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.kickstart.autoconfigure.editor.PropertyGroupReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Properties;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StreamUtils;

public class PropsLoader {
    private final Environment environment;
    private final String resourcesPrefix;
    private final String valuesPrefix;

    public PropsLoader(Environment environment, String resourcesPrefix, String valuesPrefix) {
        this.environment = environment;
        this.resourcesPrefix = resourcesPrefix;
        this.valuesPrefix = valuesPrefix;
    }

    public String load() throws IOException {
        PropertyGroupReader reader = new PropertyGroupReader(this.environment, this.valuesPrefix);
        Properties props = reader.load();
        ObjectMapper objectMapper = new ObjectMapper();
        this.loadPropFromResource("defaultQuery").ifPresent(it -> props.put("defaultQuery", it));
        this.loadPropFromResource("query").ifPresent(it -> props.put("query", it));
        this.loadPropFromResource("variables").ifPresent(it -> props.put("variables", it));
        return objectMapper.writeValueAsString((Object)props);
    }

    private Optional<String> loadPropFromResource(String prop) {
        String property = this.resourcesPrefix + prop;
        return Optional.ofNullable(this.environment.getProperty(property)).map(ClassPathResource::new).map(this::loadResource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadResource(Resource resource) {
        try (InputStream inputStream = resource.getInputStream();){
            String string = StreamUtils.copyToString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }
}

