/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet.input;

import graphql.schema.GraphQLSchema;
import graphql.servlet.config.DefaultGraphQLSchemaProvider;
import graphql.servlet.config.GraphQLSchemaProvider;
import graphql.servlet.context.ContextSetting;
import graphql.servlet.context.DefaultGraphQLContextBuilder;
import graphql.servlet.context.GraphQLContextBuilder;
import graphql.servlet.core.DefaultGraphQLRootObjectBuilder;
import graphql.servlet.core.GraphQLRootObjectBuilder;
import graphql.servlet.core.internal.GraphQLRequest;
import graphql.servlet.input.GraphQLBatchedInvocationInput;
import graphql.servlet.input.GraphQLSingleInvocationInput;
import java.util.List;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.Session;
import javax.websocket.server.HandshakeRequest;

public class GraphQLInvocationInputFactory {
    private final Supplier<GraphQLSchemaProvider> schemaProviderSupplier;
    private final Supplier<GraphQLContextBuilder> contextBuilderSupplier;
    private final Supplier<GraphQLRootObjectBuilder> rootObjectBuilderSupplier;

    protected GraphQLInvocationInputFactory(Supplier<GraphQLSchemaProvider> schemaProviderSupplier, Supplier<GraphQLContextBuilder> contextBuilderSupplier, Supplier<GraphQLRootObjectBuilder> rootObjectBuilderSupplier) {
        this.schemaProviderSupplier = schemaProviderSupplier;
        this.contextBuilderSupplier = contextBuilderSupplier;
        this.rootObjectBuilderSupplier = rootObjectBuilderSupplier;
    }

    public GraphQLSchemaProvider getSchemaProvider() {
        return this.schemaProviderSupplier.get();
    }

    public GraphQLSingleInvocationInput create(GraphQLRequest graphQLRequest, HttpServletRequest request, HttpServletResponse response) {
        return this.create(graphQLRequest, request, response, false);
    }

    public GraphQLBatchedInvocationInput create(ContextSetting contextSetting, List<GraphQLRequest> graphQLRequests, HttpServletRequest request, HttpServletResponse response) {
        return this.create(contextSetting, graphQLRequests, request, response, false);
    }

    public GraphQLSingleInvocationInput createReadOnly(GraphQLRequest graphQLRequest, HttpServletRequest request, HttpServletResponse response) {
        return this.create(graphQLRequest, request, response, true);
    }

    public GraphQLBatchedInvocationInput createReadOnly(ContextSetting contextSetting, List<GraphQLRequest> graphQLRequests, HttpServletRequest request, HttpServletResponse response) {
        return this.create(contextSetting, graphQLRequests, request, response, true);
    }

    public GraphQLSingleInvocationInput create(GraphQLRequest graphQLRequest) {
        return new GraphQLSingleInvocationInput(graphQLRequest, this.schemaProviderSupplier.get().getSchema(), this.contextBuilderSupplier.get().build(), this.rootObjectBuilderSupplier.get().build());
    }

    private GraphQLSingleInvocationInput create(GraphQLRequest graphQLRequest, HttpServletRequest request, HttpServletResponse response, boolean readOnly) {
        return new GraphQLSingleInvocationInput(graphQLRequest, readOnly ? this.schemaProviderSupplier.get().getReadOnlySchema(request) : this.schemaProviderSupplier.get().getSchema(request), this.contextBuilderSupplier.get().build(request, response), this.rootObjectBuilderSupplier.get().build(request));
    }

    private GraphQLBatchedInvocationInput create(ContextSetting contextSetting, List<GraphQLRequest> graphQLRequests, HttpServletRequest request, HttpServletResponse response, boolean readOnly) {
        return contextSetting.getBatch(graphQLRequests, readOnly ? this.schemaProviderSupplier.get().getReadOnlySchema(request) : this.schemaProviderSupplier.get().getSchema(request), () -> this.contextBuilderSupplier.get().build(request, response), this.rootObjectBuilderSupplier.get().build(request));
    }

    public GraphQLSingleInvocationInput create(GraphQLRequest graphQLRequest, Session session, HandshakeRequest request) {
        return new GraphQLSingleInvocationInput(graphQLRequest, this.schemaProviderSupplier.get().getSchema(request), this.contextBuilderSupplier.get().build(session, request), this.rootObjectBuilderSupplier.get().build(request));
    }

    public GraphQLBatchedInvocationInput create(ContextSetting contextSetting, List<GraphQLRequest> graphQLRequest, Session session, HandshakeRequest request) {
        return contextSetting.getBatch(graphQLRequest, this.schemaProviderSupplier.get().getSchema(request), () -> this.contextBuilderSupplier.get().build(session, request), this.rootObjectBuilderSupplier.get().build(request));
    }

    public static Builder newBuilder(GraphQLSchema schema) {
        return new Builder(new DefaultGraphQLSchemaProvider(schema));
    }

    public static Builder newBuilder(GraphQLSchemaProvider schemaProvider) {
        return new Builder(schemaProvider);
    }

    public static Builder newBuilder(Supplier<GraphQLSchemaProvider> schemaProviderSupplier) {
        return new Builder(schemaProviderSupplier);
    }

    public static class Builder {
        private final Supplier<GraphQLSchemaProvider> schemaProviderSupplier;
        private Supplier<GraphQLContextBuilder> contextBuilderSupplier = DefaultGraphQLContextBuilder::new;
        private Supplier<GraphQLRootObjectBuilder> rootObjectBuilderSupplier = DefaultGraphQLRootObjectBuilder::new;

        public Builder(GraphQLSchemaProvider schemaProvider) {
            this(() -> schemaProvider);
        }

        public Builder(Supplier<GraphQLSchemaProvider> schemaProviderSupplier) {
            this.schemaProviderSupplier = schemaProviderSupplier;
        }

        public Builder withGraphQLContextBuilder(GraphQLContextBuilder contextBuilder) {
            return this.withGraphQLContextBuilder(() -> contextBuilder);
        }

        public Builder withGraphQLContextBuilder(Supplier<GraphQLContextBuilder> contextBuilderSupplier) {
            this.contextBuilderSupplier = contextBuilderSupplier;
            return this;
        }

        public Builder withGraphQLRootObjectBuilder(GraphQLRootObjectBuilder rootObjectBuilder) {
            return this.withGraphQLRootObjectBuilder(() -> rootObjectBuilder);
        }

        public Builder withGraphQLRootObjectBuilder(Supplier<GraphQLRootObjectBuilder> rootObjectBuilderSupplier) {
            this.rootObjectBuilderSupplier = rootObjectBuilderSupplier;
            return this;
        }

        public GraphQLInvocationInputFactory build() {
            return new GraphQLInvocationInputFactory(this.schemaProviderSupplier, this.contextBuilderSupplier, this.rootObjectBuilderSupplier);
        }
    }
}

