/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet.core.internal;

import graphql.servlet.core.internal.GraphQLRequest;
import graphql.servlet.core.internal.SubscriptionHandlerInput;
import graphql.servlet.core.internal.SubscriptionProtocolHandler;
import graphql.servlet.core.internal.SubscriptionSender;
import graphql.servlet.core.internal.WsSessionSubscriptions;
import graphql.servlet.input.GraphQLSingleInvocationInput;
import java.io.IOException;
import java.util.UUID;
import javax.websocket.Session;
import javax.websocket.server.HandshakeRequest;

public class FallbackSubscriptionProtocolHandler
extends SubscriptionProtocolHandler {
    private final SubscriptionHandlerInput input;
    private final SubscriptionSender sender;

    public FallbackSubscriptionProtocolHandler(SubscriptionHandlerInput subscriptionHandlerInput) {
        this.input = subscriptionHandlerInput;
        this.sender = new SubscriptionSender(subscriptionHandlerInput.getGraphQLObjectMapper().getJacksonMapper());
    }

    @Override
    public void onMessage(HandshakeRequest request, Session session, WsSessionSubscriptions subscriptions, String text) throws Exception {
        GraphQLSingleInvocationInput graphQLSingleInvocationInput = this.createInvocationInput(session, text);
        this.subscribe(session, this.input.getQueryInvoker().query(graphQLSingleInvocationInput), subscriptions, UUID.randomUUID().toString());
    }

    private GraphQLSingleInvocationInput createInvocationInput(Session session, String text) throws IOException {
        GraphQLRequest graphQLRequest = this.input.getGraphQLObjectMapper().readGraphQLRequest(text);
        HandshakeRequest handshakeRequest = (HandshakeRequest)session.getUserProperties().get(HandshakeRequest.class.getName());
        return this.input.getInvocationInputFactory().create(graphQLRequest, session, handshakeRequest);
    }

    @Override
    protected void sendDataMessage(Session session, String id, Object payload) {
        this.sender.send(session, payload);
    }

    @Override
    protected void sendErrorMessage(Session session, String id) {
    }

    @Override
    protected void sendCompleteMessage(Session session, String id) {
    }
}

