package graphql.servlet;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;

/**
 * @author Andrew Potter
 */
public class DefaultObjectMapperConfigurer implements ObjectMapperConfigurer {

    @Override
    public void configure(ObjectMapper mapper) {
        // default configuration for GraphQL Java Servlet
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        mapper.registerModule(new Jdk8Module());
        mapper.setDefaultPropertyInclusion(JsonInclude.Include.ALWAYS);
    }
}
