/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet;

import graphql.ExecutionInput;
import graphql.schema.GraphQLSchema;
import graphql.servlet.GraphQLContext;
import graphql.servlet.internal.GraphQLRequest;
import java.util.Optional;
import javax.security.auth.Subject;
import org.dataloader.DataLoaderRegistry;

public abstract class GraphQLInvocationInput {
    private final GraphQLSchema schema;
    private final GraphQLContext context;
    private final Object root;

    public GraphQLInvocationInput(GraphQLSchema schema, GraphQLContext context, Object root) {
        this.schema = schema;
        this.context = context;
        this.root = root;
    }

    public GraphQLSchema getSchema() {
        return this.schema;
    }

    public GraphQLContext getContext() {
        return this.context;
    }

    public Object getRoot() {
        return this.root;
    }

    public Optional<Subject> getSubject() {
        return this.context.getSubject();
    }

    protected ExecutionInput createExecutionInput(GraphQLRequest graphQLRequest) {
        return ExecutionInput.newExecutionInput().query(graphQLRequest.getQuery()).operationName(graphQLRequest.getOperationName()).context((Object)this.context).root(this.root).variables(graphQLRequest.getVariables()).dataLoaderRegistry(this.context.getDataLoaderRegistry().orElse(new DataLoaderRegistry())).build();
    }
}

