/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.servlet;

import com.fasterxml.jackson.core.JsonProcessingException;
import graphql.GraphQLException;
import graphql.kickstart.execution.input.GraphQLInvocationInput;
import graphql.kickstart.servlet.GraphQLConfiguration;
import graphql.kickstart.servlet.GraphQLInvocationInputParser;
import graphql.kickstart.servlet.HttpRequestHandler;
import graphql.kickstart.servlet.HttpRequestInvoker;
import graphql.kickstart.servlet.HttpRequestInvokerImpl;
import graphql.kickstart.servlet.QueryResponseWriterFactoryImpl;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpRequestHandlerImpl
implements HttpRequestHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpRequestHandlerImpl.class);
    private final GraphQLConfiguration configuration;
    private final HttpRequestInvoker requestInvoker;

    public HttpRequestHandlerImpl(GraphQLConfiguration configuration) {
        this(configuration, new HttpRequestInvokerImpl(configuration, configuration.getGraphQLInvoker(), new QueryResponseWriterFactoryImpl()));
    }

    public HttpRequestHandlerImpl(GraphQLConfiguration configuration, HttpRequestInvoker requestInvoker) {
        this.configuration = configuration;
        this.requestInvoker = requestInvoker;
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            GraphQLInvocationInputParser invocationInputParser = GraphQLInvocationInputParser.create(request, this.configuration.getInvocationInputFactory(), this.configuration.getObjectMapper(), this.configuration.getContextSetting());
            GraphQLInvocationInput invocationInput = invocationInputParser.getGraphQLInvocationInput(request, response);
            this.requestInvoker.execute(invocationInput, request, response);
        }
        catch (JsonProcessingException | GraphQLException e) {
            response.setStatus(400);
            log.info("Bad request: cannot handle http request", e);
            throw e;
        }
        catch (Exception t) {
            response.setStatus(500);
            log.error("Cannot handle http request", (Throwable)t);
            throw t;
        }
    }
}

