/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.execution.subscriptions.apollo;

import graphql.kickstart.execution.GraphQLInvoker;
import graphql.kickstart.execution.GraphQLObjectMapper;
import graphql.kickstart.execution.subscriptions.GraphQLSubscriptionInvocationInputFactory;
import graphql.kickstart.execution.subscriptions.GraphQLSubscriptionMapper;
import graphql.kickstart.execution.subscriptions.SubscriptionProtocolFactory;
import graphql.kickstart.execution.subscriptions.SubscriptionSession;
import graphql.kickstart.execution.subscriptions.apollo.ApolloCommandProvider;
import graphql.kickstart.execution.subscriptions.apollo.ApolloSubscriptionConnectionListener;
import graphql.kickstart.execution.subscriptions.apollo.ApolloSubscriptionConsumer;
import graphql.kickstart.execution.subscriptions.apollo.KeepAliveSubscriptionConnectionListener;
import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Consumer;
import lombok.Generated;

public class ApolloSubscriptionProtocolFactory
extends SubscriptionProtocolFactory {
    public static final int KEEP_ALIVE_INTERVAL = 15;
    private final GraphQLObjectMapper objectMapper;
    private final ApolloCommandProvider commandProvider;

    public ApolloSubscriptionProtocolFactory(GraphQLObjectMapper objectMapper, GraphQLSubscriptionInvocationInputFactory invocationInputFactory, GraphQLInvoker graphQLInvoker) {
        this(objectMapper, invocationInputFactory, graphQLInvoker, Duration.ofSeconds(15L));
    }

    public ApolloSubscriptionProtocolFactory(GraphQLObjectMapper objectMapper, GraphQLSubscriptionInvocationInputFactory invocationInputFactory, GraphQLInvoker graphQLInvoker, Duration keepAliveInterval) {
        this(objectMapper, invocationInputFactory, graphQLInvoker, null, keepAliveInterval);
    }

    public ApolloSubscriptionProtocolFactory(GraphQLObjectMapper objectMapper, GraphQLSubscriptionInvocationInputFactory invocationInputFactory, GraphQLInvoker graphQLInvoker, Collection<ApolloSubscriptionConnectionListener> connectionListeners) {
        this(objectMapper, invocationInputFactory, graphQLInvoker, connectionListeners, Duration.ofSeconds(15L));
    }

    public ApolloSubscriptionProtocolFactory(GraphQLObjectMapper objectMapper, GraphQLSubscriptionInvocationInputFactory invocationInputFactory, GraphQLInvoker graphQLInvoker, Collection<ApolloSubscriptionConnectionListener> connectionListeners, Duration keepAliveInterval) {
        super("graphql-ws");
        this.objectMapper = objectMapper;
        HashSet<ApolloSubscriptionConnectionListener> listeners = new HashSet<ApolloSubscriptionConnectionListener>();
        if (connectionListeners != null) {
            listeners.addAll(connectionListeners);
        }
        if (keepAliveInterval != null) {
            if (listeners.stream().noneMatch(KeepAliveSubscriptionConnectionListener.class::isInstance)) {
                listeners.add(new KeepAliveSubscriptionConnectionListener(keepAliveInterval));
            }
        }
        this.commandProvider = new ApolloCommandProvider(new GraphQLSubscriptionMapper(objectMapper), invocationInputFactory, graphQLInvoker, listeners);
    }

    @Override
    public Consumer<String> createConsumer(SubscriptionSession session) {
        return new ApolloSubscriptionConsumer(session, this.objectMapper, this.commandProvider);
    }

    @Generated
    public GraphQLObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

