/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.execution.subscriptions.apollo;

import graphql.kickstart.execution.subscriptions.SubscriptionSession;
import graphql.kickstart.execution.subscriptions.apollo.OperationMessage;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ApolloSubscriptionKeepAliveRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApolloSubscriptionKeepAliveRunner.class);
    private static final int EXECUTOR_POOL_SIZE = 10;
    private final ScheduledExecutorService executor;
    private final OperationMessage keepAliveMessage = OperationMessage.newKeepAliveMessage();
    private final Map<SubscriptionSession, Future<?>> futures;
    private final long keepAliveIntervalSeconds;

    ApolloSubscriptionKeepAliveRunner(Duration keepAliveInterval) {
        this.executor = Executors.newScheduledThreadPool(10);
        this.futures = new ConcurrentHashMap();
        this.keepAliveIntervalSeconds = keepAliveInterval.getSeconds();
    }

    void keepAlive(SubscriptionSession session) {
        this.futures.computeIfAbsent(session, this::startKeepAlive);
    }

    private ScheduledFuture<?> startKeepAlive(SubscriptionSession session) {
        return this.executor.scheduleAtFixedRate(() -> {
            try {
                if (session.isOpen()) {
                    session.sendMessage(this.keepAliveMessage);
                } else {
                    log.debug("Session {} appears to be closed. Aborting keep alive", (Object)session.getId());
                    this.abort(session);
                }
            }
            catch (Exception t) {
                log.error("Cannot send keep alive message to session {}. Aborting keep alive", (Object)session.getId(), (Object)t);
                this.abort(session);
            }
        }, 0L, this.keepAliveIntervalSeconds, TimeUnit.SECONDS);
    }

    void abort(SubscriptionSession session) {
        Future<?> future = this.futures.remove(session);
        if (future != null) {
            future.cancel(true);
        }
    }
}

