/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.execution.subscriptions;

import graphql.ExecutionResult;
import graphql.execution.reactive.SingleSubscriberPublisher;
import graphql.kickstart.execution.subscriptions.GraphQLSubscriptionMapper;
import graphql.kickstart.execution.subscriptions.SessionSubscriber;
import graphql.kickstart.execution.subscriptions.SessionSubscriptions;
import graphql.kickstart.execution.subscriptions.SubscriptionSession;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSubscriptionSession
implements SubscriptionSession {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultSubscriptionSession.class);
    private final GraphQLSubscriptionMapper mapper;
    private SingleSubscriberPublisher<String> publisher = new SingleSubscriberPublisher();
    private SessionSubscriptions subscriptions = new SessionSubscriptions();

    @Override
    public void send(String message) {
        Objects.requireNonNull(message, "message is required");
        this.publisher.offer((Object)message);
    }

    @Override
    public void sendMessage(Object payload) {
        Objects.requireNonNull(payload, "payload is required");
        this.send(this.mapper.serialize(payload));
    }

    @Override
    public void subscribe(String id, Publisher<ExecutionResult> dataPublisher) {
        dataPublisher.subscribe((Subscriber)new SessionSubscriber(this, id));
    }

    @Override
    public void add(String id, Subscription subscription) {
        this.subscriptions.add(id, subscription);
    }

    @Override
    public void unsubscribe(String id) {
        this.subscriptions.cancel(id);
    }

    @Override
    public void sendDataMessage(String id, Object payload) {
        this.send(this.mapper.serialize(payload));
    }

    @Override
    public void sendErrorMessage(String id, Object payload) {
        this.send(this.mapper.serialize(payload));
    }

    @Override
    public void sendCompleteMessage(String id) {
    }

    @Override
    public void close(String reason) {
        log.debug("Closing subscription session {}", (Object)this.getId());
        this.subscriptions.close();
        this.publisher.noMoreData();
    }

    @Override
    public Map<String, Object> getUserProperties() {
        return new HashMap<String, Object>();
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public SessionSubscriptions getSubscriptions() {
        return this.subscriptions;
    }

    @Override
    public Object unwrap() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Publisher<String> getPublisher() {
        return this.publisher;
    }

    public String toString() {
        return this.getId();
    }

    @Generated
    public DefaultSubscriptionSession(GraphQLSubscriptionMapper mapper) {
        this.mapper = mapper;
    }

    @Generated
    public GraphQLSubscriptionMapper getMapper() {
        return this.mapper;
    }
}

