/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.execution.context;

import graphql.ExecutionInput;
import graphql.execution.ExecutionId;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.dataloader.DataLoaderDispatcherInstrumentationOptions;
import graphql.kickstart.execution.GraphQLRequest;
import graphql.kickstart.execution.context.ContextSettingNotConfiguredException;
import graphql.kickstart.execution.context.GraphQLContext;
import graphql.kickstart.execution.input.GraphQLBatchedInvocationInput;
import graphql.kickstart.execution.input.PerQueryBatchedInvocationInput;
import graphql.kickstart.execution.input.PerRequestBatchedInvocationInput;
import graphql.kickstart.execution.instrumentation.ConfigurableDispatchInstrumentation;
import graphql.kickstart.execution.instrumentation.FieldLevelTrackingApproach;
import graphql.kickstart.execution.instrumentation.RequestLevelTrackingApproach;
import graphql.schema.GraphQLSchema;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.dataloader.DataLoaderRegistry;

public enum ContextSetting {
    PER_REQUEST_WITH_INSTRUMENTATION,
    PER_REQUEST_WITHOUT_INSTRUMENTATION,
    PER_QUERY_WITH_INSTRUMENTATION,
    PER_QUERY_WITHOUT_INSTRUMENTATION;


    public GraphQLBatchedInvocationInput getBatch(List<GraphQLRequest> requests, GraphQLSchema schema, Supplier<GraphQLContext> contextSupplier, Object root) {
        switch (this) {
            case PER_QUERY_WITH_INSTRUMENTATION: 
            case PER_QUERY_WITHOUT_INSTRUMENTATION: {
                return new PerQueryBatchedInvocationInput(requests, schema, contextSupplier, root, this);
            }
            case PER_REQUEST_WITHOUT_INSTRUMENTATION: 
            case PER_REQUEST_WITH_INSTRUMENTATION: {
                return new PerRequestBatchedInvocationInput(requests, schema, contextSupplier, root, this);
            }
        }
        throw new ContextSettingNotConfiguredException();
    }

    public Supplier<Instrumentation> configureInstrumentationForContext(Supplier<Instrumentation> instrumentation, List<ExecutionInput> executionInputs, DataLoaderDispatcherInstrumentationOptions options) {
        ConfigurableDispatchInstrumentation dispatchInstrumentation;
        switch (this) {
            case PER_REQUEST_WITH_INSTRUMENTATION: {
                DataLoaderRegistry registry = executionInputs.stream().findFirst().map(ExecutionInput::getDataLoaderRegistry).orElseThrow(IllegalArgumentException::new);
                List<ExecutionId> executionIds = executionInputs.stream().map(ExecutionInput::getExecutionId).collect(Collectors.toList());
                RequestLevelTrackingApproach requestTrackingApproach = new RequestLevelTrackingApproach(executionIds, registry);
                dispatchInstrumentation = new ConfigurableDispatchInstrumentation(options, dataLoaderRegistry -> requestTrackingApproach);
                break;
            }
            case PER_QUERY_WITH_INSTRUMENTATION: {
                dispatchInstrumentation = new ConfigurableDispatchInstrumentation(options, FieldLevelTrackingApproach::new);
                break;
            }
            case PER_QUERY_WITHOUT_INSTRUMENTATION: 
            case PER_REQUEST_WITHOUT_INSTRUMENTATION: {
                return instrumentation;
            }
            default: {
                throw new ContextSettingNotConfiguredException();
            }
        }
        return () -> new ChainedInstrumentation(Arrays.asList(new Instrumentation[]{dispatchInstrumentation, (Instrumentation)instrumentation.get()}));
    }
}

