/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.lm;

import com.graphhopper.routing.Dijkstra;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.WeightApproximator;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;

public class PerfectApproximator
implements WeightApproximator {
    private Graph graph;
    private Weighting weighting;
    private TraversalMode traversalMode;
    private int to;
    private boolean reverse;

    public PerfectApproximator(Graph graph, Weighting weighting, TraversalMode traversalMode, boolean reverse) {
        this.graph = graph;
        this.weighting = weighting;
        this.traversalMode = traversalMode;
        this.reverse = reverse;
    }

    @Override
    public double approximate(int currentNode) {
        Dijkstra dijkstra = new Dijkstra(this.graph, this.weighting, this.traversalMode);
        Path path = this.reverse ? dijkstra.calcPath(this.to, currentNode) : dijkstra.calcPath(currentNode, this.to);
        return path.isFound() ? path.getWeight() : Double.POSITIVE_INFINITY;
    }

    @Override
    public void setTo(int to) {
        this.to = to;
    }

    @Override
    public WeightApproximator reverse() {
        return new PerfectApproximator(this.graph, this.weighting, this.traversalMode, !this.reverse);
    }

    @Override
    public double getSlack() {
        return 0.0;
    }
}

