/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.graphhopper.util.Helper;

public enum RouteNetwork {
    MISSING("missing"),
    INTERNATIONAL("international"),
    NATIONAL("national"),
    REGIONAL("regional"),
    LOCAL("local"),
    OTHER("other");

    private final String name;

    public static String key(String prefix) {
        return prefix + "_network";
    }

    private RouteNetwork(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static RouteNetwork find(String name) {
        if (Helper.isEmpty(name)) {
            return MISSING;
        }
        try {
            return RouteNetwork.valueOf(Helper.toUpperCase(name));
        }
        catch (IllegalArgumentException ex) {
            return MISSING;
        }
    }
}

