/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.matching;

import com.graphhopper.matching.Distributions;

public class HmmProbabilities {
    private final double sigma;
    private final double beta;

    public HmmProbabilities(double sigma, double beta) {
        this.sigma = sigma;
        this.beta = beta;
    }

    public double emissionLogProbability(double distance) {
        return Distributions.logNormalDistribution(this.sigma, distance);
    }

    public double transitionLogProbability(double routeLength, double linearDistance) {
        double transitionMetric = Math.abs(linearDistance - routeLength);
        return Distributions.logExponentialDistribution(this.beta, transitionMetric);
    }
}

