/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs;

import com.conveyal.gtfs.GTFSFeed;
import com.google.transit.realtime.GtfsRealtime;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopper;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.ResponsePath;
import com.graphhopper.config.Profile;
import com.graphhopper.gtfs.GHLocation;
import com.graphhopper.gtfs.GHPointLocation;
import com.graphhopper.gtfs.GHStationLocation;
import com.graphhopper.gtfs.GraphExplorer;
import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.Label;
import com.graphhopper.gtfs.MultiCriteriaLabelSetting;
import com.graphhopper.gtfs.PtEncodedValues;
import com.graphhopper.gtfs.PtRouter;
import com.graphhopper.gtfs.RealtimeFeed;
import com.graphhopper.gtfs.Request;
import com.graphhopper.gtfs.Transfers;
import com.graphhopper.gtfs.TripFromLabel;
import com.graphhopper.gtfs.WrapperGraph;
import com.graphhopper.routing.DefaultWeightingFactory;
import com.graphhopper.routing.WeightingFactory;
import com.graphhopper.routing.ev.Subnetwork;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.querygraph.VirtualEdgeIteratorState;
import com.graphhopper.routing.util.DefaultSnapFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.weighting.FastestWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.PMap;
import com.graphhopper.util.PointList;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.Translation;
import com.graphhopper.util.TranslationMap;
import com.graphhopper.util.details.PathDetailsBuilderFactory;
import com.graphhopper.util.exceptions.PointNotFoundException;
import com.graphhopper.util.shapes.GHPoint;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

public final class PtRouterImpl
implements PtRouter {
    private final GraphHopperConfig config;
    private final TranslationMap translationMap;
    private final PtEncodedValues ptEncodedValues;
    private final GraphHopperStorage graphHopperStorage;
    private final LocationIndex locationIndex;
    private final GtfsStorage gtfsStorage;
    private final RealtimeFeed realtimeFeed;
    private final TripFromLabel tripFromLabel;
    private final WeightingFactory weightingFactory;

    @Inject
    public PtRouterImpl(GraphHopperConfig config, TranslationMap translationMap, GraphHopperStorage graphHopperStorage, LocationIndex locationIndex, GtfsStorage gtfsStorage, RealtimeFeed realtimeFeed, PathDetailsBuilderFactory pathDetailsBuilderFactory) {
        this.config = config;
        this.ptEncodedValues = PtEncodedValues.fromEncodingManager(graphHopperStorage.getEncodingManager());
        this.weightingFactory = new DefaultWeightingFactory(graphHopperStorage, graphHopperStorage.getEncodingManager());
        this.translationMap = translationMap;
        this.graphHopperStorage = graphHopperStorage;
        this.locationIndex = locationIndex;
        this.gtfsStorage = gtfsStorage;
        this.realtimeFeed = realtimeFeed;
        this.tripFromLabel = new TripFromLabel(this.graphHopperStorage, this.gtfsStorage, this.realtimeFeed, pathDetailsBuilderFactory);
    }

    public static Factory createFactory(GraphHopperConfig config, TranslationMap translationMap, GraphHopper graphHopperStorage, LocationIndex locationIndex, GtfsStorage gtfsStorage) {
        return new Factory(config, translationMap, graphHopperStorage.getGraphHopperStorage(), locationIndex, gtfsStorage);
    }

    @Override
    public GHResponse route(Request request) {
        return new RequestHandler(request).route();
    }

    private class RequestHandler {
        private final int maxVisitedNodesForRequest;
        private final int limitSolutions;
        private final long maxProfileDuration;
        private final Instant initialTime;
        private final boolean profileQuery;
        private final boolean arriveBy;
        private final boolean ignoreTransfers;
        private final double betaTransfers;
        private final double betaStreetTime;
        private final double walkSpeedKmH;
        private final int blockedRouteTypes;
        private final GHLocation enter;
        private final GHLocation exit;
        private final Translation translation;
        private final List<String> requestedPathDetails;
        private final List<VirtualEdgeIteratorState> extraEdges;
        private final GHResponse response;
        private final Graph graphWithExtraEdges;
        private final long limitTripTime;
        private final long limitStreetTime;
        private QueryGraph queryGraph;
        private int visitedNodes;
        private MultiCriteriaLabelSetting router;
        private final Profile accessProfile;
        private final EdgeFilter accessSnapFilter;
        private final Weighting accessWeighting;
        private final Profile egressProfile;
        private final EdgeFilter egressSnapFilter;
        private final Weighting egressWeighting;

        RequestHandler(Request request) {
            this.extraEdges = new ArrayList<VirtualEdgeIteratorState>(PtRouterImpl.this.realtimeFeed.getAdditionalEdges());
            this.response = new GHResponse();
            this.graphWithExtraEdges = new WrapperGraph(PtRouterImpl.this.graphHopperStorage, this.extraEdges);
            this.maxVisitedNodesForRequest = request.getMaxVisitedNodes();
            this.profileQuery = request.isProfileQuery();
            this.ignoreTransfers = Optional.ofNullable(request.getIgnoreTransfers()).orElse(request.isProfileQuery());
            this.betaTransfers = request.getBetaTransfers();
            this.betaStreetTime = request.getBetaStreetTime();
            this.limitSolutions = Optional.ofNullable(request.getLimitSolutions()).orElse(this.profileQuery ? 50 : (this.ignoreTransfers ? 1 : Integer.MAX_VALUE));
            this.initialTime = request.getEarliestDepartureTime();
            this.maxProfileDuration = request.getMaxProfileDuration().toMillis();
            this.arriveBy = request.isArriveBy();
            this.walkSpeedKmH = request.getWalkSpeedKmH();
            this.blockedRouteTypes = request.getBlockedRouteTypes();
            this.translation = PtRouterImpl.this.translationMap.getWithFallBack(request.getLocale());
            this.enter = request.getPoints().get(0);
            this.exit = request.getPoints().get(1);
            this.limitTripTime = request.getLimitTripTime() != null ? request.getLimitTripTime().toMillis() : Long.MAX_VALUE;
            this.limitStreetTime = request.getLimitStreetTime() != null ? request.getLimitStreetTime().toMillis() : Long.MAX_VALUE;
            this.requestedPathDetails = request.getPathDetails();
            this.accessProfile = PtRouterImpl.this.config.getProfiles().stream().filter(p -> p.getName().equals(request.getAccessProfile())).findFirst().get();
            this.accessWeighting = PtRouterImpl.this.weightingFactory.createWeighting(this.accessProfile, new PMap(), false);
            this.accessSnapFilter = new DefaultSnapFilter(new FastestWeighting(PtRouterImpl.this.graphHopperStorage.getEncodingManager().getEncoder(this.accessProfile.getVehicle())), PtRouterImpl.this.graphHopperStorage.getEncodingManager().getBooleanEncodedValue(Subnetwork.key(this.accessProfile.getVehicle())));
            this.egressProfile = PtRouterImpl.this.config.getProfiles().stream().filter(p -> p.getName().equals(request.getEgressProfile())).findFirst().get();
            this.egressWeighting = PtRouterImpl.this.weightingFactory.createWeighting(this.egressProfile, new PMap(), false);
            this.egressSnapFilter = new DefaultSnapFilter(new FastestWeighting(PtRouterImpl.this.graphHopperStorage.getEncodingManager().getEncoder(this.egressProfile.getVehicle())), PtRouterImpl.this.graphHopperStorage.getEncodingManager().getBooleanEncodedValue(Subnetwork.key(this.egressProfile.getVehicle())));
        }

        GHResponse route() {
            int destNode;
            int startNode;
            StopWatch stopWatch = new StopWatch().start();
            ArrayList<Snap> pointSnaps = new ArrayList<Snap>();
            ArrayList<Snap> allSnaps = new ArrayList<Snap>();
            PointList points = new PointList(2, false);
            List<GHLocation> locations = Arrays.asList(this.enter, this.exit);
            for (int i = 0; i < locations.size(); ++i) {
                GHLocation location = locations.get(i);
                if (location instanceof GHPointLocation) {
                    Snap closest = this.findByPoint(((GHPointLocation)location).ghPoint, i, i == 0 ? this.accessSnapFilter : this.egressSnapFilter);
                    pointSnaps.add(closest);
                    allSnaps.add(closest);
                    points.add(closest.getSnappedPoint());
                    continue;
                }
                if (!(location instanceof GHStationLocation)) continue;
                Snap station = this.findByStationId((GHStationLocation)location, i);
                allSnaps.add(station);
                points.add(PtRouterImpl.this.graphHopperStorage.getNodeAccess().getLat(station.getClosestNode()), PtRouterImpl.this.graphHopperStorage.getNodeAccess().getLon(station.getClosestNode()));
            }
            this.queryGraph = QueryGraph.create(this.graphWithExtraEdges, pointSnaps);
            this.response.addDebugInfo("idLookup:" + stopWatch.stop().getSeconds() + "s");
            if (this.arriveBy) {
                startNode = ((Snap)allSnaps.get(1)).getClosestNode();
                destNode = ((Snap)allSnaps.get(0)).getClosestNode();
            } else {
                startNode = ((Snap)allSnaps.get(0)).getClosestNode();
                destNode = ((Snap)allSnaps.get(1)).getClosestNode();
            }
            List<List<Label.Transition>> solutions = this.findPaths(startNode, destNode);
            this.parseSolutionsAndAddToResponse(solutions, points);
            return this.response;
        }

        private Snap findByPoint(GHPoint point, int indexForErrorMessage, EdgeFilter snapFilter) {
            Snap source = PtRouterImpl.this.locationIndex.findClosest(point.lat, point.lon, snapFilter);
            if (!source.isValid()) {
                throw new PointNotFoundException("Cannot find point: " + point, indexForErrorMessage);
            }
            if (source.getClosestEdge().get(PtRouterImpl.this.ptEncodedValues.getTypeEnc()) != GtfsStorage.EdgeType.HIGHWAY) {
                throw new RuntimeException(source.getClosestEdge().get(PtRouterImpl.this.ptEncodedValues.getTypeEnc()).name());
            }
            return source;
        }

        private Snap findByStationId(GHStationLocation station, int indexForErrorMessage) {
            for (Map.Entry<String, GTFSFeed> entry : PtRouterImpl.this.gtfsStorage.getGtfsFeeds().entrySet()) {
                Integer node = PtRouterImpl.this.gtfsStorage.getStationNodes().get(new GtfsStorage.FeedIdWithStopId(entry.getKey(), station.stop_id));
                if (node == null) continue;
                Snap stationSnap = new Snap(PtRouterImpl.this.graphHopperStorage.getNodeAccess().getLat(node), PtRouterImpl.this.graphHopperStorage.getNodeAccess().getLon(node));
                stationSnap.setClosestNode(node);
                return stationSnap;
            }
            throw new PointNotFoundException("Cannot find station: " + station.stop_id, indexForErrorMessage);
        }

        private void parseSolutionsAndAddToResponse(List<List<Label.Transition>> solutions, PointList waypoints) {
            for (List<Label.Transition> solution : solutions) {
                ResponsePath responsePath = PtRouterImpl.this.tripFromLabel.createResponsePath(this.translation, waypoints, this.queryGraph, this.accessWeighting, this.egressWeighting, solution, this.requestedPathDetails);
                responsePath.setImpossible(solution.stream().anyMatch(t -> t.label.impossible));
                responsePath.setTime(solution.get((int)(solution.size() - 1)).label.currentTime - solution.get((int)0).label.currentTime);
                responsePath.setRouteWeight(this.router.weight(solution.get((int)(solution.size() - 1)).label));
                this.response.add(responsePath);
            }
            Comparator<ResponsePath> c = Comparator.comparingInt(p -> p.isImpossible() ? 1 : 0);
            Comparator<ResponsePath> d = Comparator.comparingDouble(ResponsePath::getTime);
            this.response.getAll().sort(c.thenComparing(d));
        }

        private List<List<Label.Transition>> findPaths(int startNode, int destNode) {
            StopWatch stopWatch = new StopWatch().start();
            boolean isEgress = !this.arriveBy;
            GraphExplorer accessEgressGraphExplorer = new GraphExplorer(this.queryGraph, isEgress ? this.egressWeighting : this.accessWeighting, PtRouterImpl.this.ptEncodedValues, PtRouterImpl.this.gtfsStorage, PtRouterImpl.this.realtimeFeed, isEgress, true, false, this.walkSpeedKmH, false, this.blockedRouteTypes);
            GtfsStorage.EdgeType edgeType = isEgress ? GtfsStorage.EdgeType.EXIT_PT : GtfsStorage.EdgeType.ENTER_PT;
            MultiCriteriaLabelSetting stationRouter = new MultiCriteriaLabelSetting(accessEgressGraphExplorer, PtRouterImpl.this.ptEncodedValues, isEgress, false, false, this.maxProfileDuration, new ArrayList<Label>());
            stationRouter.setBetaStreetTime(this.betaStreetTime);
            stationRouter.setLimitStreetTime(this.limitStreetTime);
            Iterator stationIterator = stationRouter.calcLabels(destNode, this.initialTime).iterator();
            ArrayList<Label> stationLabels = new ArrayList<Label>();
            while (stationIterator.hasNext()) {
                Label label = (Label)stationIterator.next();
                ++this.visitedNodes;
                if (label.adjNode == startNode) {
                    stationLabels.add(label);
                    break;
                }
                if (label.edge == -1 || this.queryGraph.getEdgeIteratorState(label.edge, label.parent.adjNode).get(PtRouterImpl.this.ptEncodedValues.getTypeEnc()) != edgeType) continue;
                stationLabels.add(label);
            }
            HashMap<Integer, Label> reverseSettledSet = new HashMap<Integer, Label>();
            for (Label stationLabel : stationLabels) {
                reverseSettledSet.put(stationLabel.adjNode, stationLabel);
            }
            GraphExplorer graphExplorer = new GraphExplorer(this.queryGraph, this.arriveBy ? this.egressWeighting : this.accessWeighting, PtRouterImpl.this.ptEncodedValues, PtRouterImpl.this.gtfsStorage, PtRouterImpl.this.realtimeFeed, this.arriveBy, false, true, this.walkSpeedKmH, false, this.blockedRouteTypes);
            ArrayList<Label> discoveredSolutions = new ArrayList<Label>();
            this.router = new MultiCriteriaLabelSetting(graphExplorer, PtRouterImpl.this.ptEncodedValues, this.arriveBy, !this.ignoreTransfers, this.profileQuery, this.maxProfileDuration, discoveredSolutions);
            this.router.setBetaTransfers(this.betaTransfers);
            this.router.setBetaStreetTime(this.betaStreetTime);
            long smallestStationLabelWalkTime = stationLabels.stream().mapToLong(l -> l.streetTime).min().orElse(Long.MAX_VALUE);
            this.router.setLimitTripTime(Math.max(0L, this.limitTripTime - smallestStationLabelWalkTime));
            this.router.setLimitStreetTime(Math.max(0L, this.limitStreetTime - smallestStationLabelWalkTime));
            long smallestStationLabelWeight = !stationLabels.isEmpty() ? stationRouter.weight((Label)stationLabels.get(0)) : Long.MAX_VALUE;
            Iterator iterator = this.router.calcLabels(startNode, this.initialTime).iterator();
            HashMap<Label, Label> originalSolutions = new HashMap<Label, Label>();
            Label accessEgressModeOnlySolution = null;
            long highestWeightForDominationTest = Long.MAX_VALUE;
            while (iterator.hasNext()) {
                List otherSolutions;
                ArrayList<Label> filteredSolutions;
                Label label = (Label)iterator.next();
                ++this.visitedNodes;
                if (this.visitedNodes >= this.maxVisitedNodesForRequest || (!this.profileQuery || this.profileFinished(this.router, discoveredSolutions, accessEgressModeOnlySolution)) && this.router.weight(label) + smallestStationLabelWeight > highestWeightForDominationTest) break;
                Label reverseLabel = (Label)reverseSettledSet.get(label.adjNode);
                if (reverseLabel == null) continue;
                Label combinedSolution = new Label(label.currentTime - reverseLabel.currentTime + this.initialTime.toEpochMilli(), -1, label.adjNode, label.nTransfers + reverseLabel.nTransfers, label.departureTime, label.streetTime + reverseLabel.streetTime, 0L, label.impossible, null);
                if (this.profileQuery && combinedSolution.departureTime != null) {
                    Map<Boolean, List<Label>> partitionedSptEntries = this.router.partitionByProfileCriterion(combinedSolution, discoveredSolutions);
                    filteredSolutions = new ArrayList(partitionedSptEntries.get(true));
                    otherSolutions = new ArrayList((Collection)partitionedSptEntries.get(false));
                } else {
                    filteredSolutions = new ArrayList<Label>(discoveredSolutions);
                    otherSolutions = Collections.emptyList();
                }
                if (!this.router.isNotDominatedByAnyOf(combinedSolution, filteredSolutions)) continue;
                this.router.removeDominated(combinedSolution, filteredSolutions);
                discoveredSolutions.clear();
                discoveredSolutions.addAll(filteredSolutions);
                discoveredSolutions.addAll(otherSolutions);
                List closedSolutions = discoveredSolutions.stream().filter(s2 -> this.router.weight((Label)s2) < this.router.weight(label) + smallestStationLabelWeight).collect(Collectors.toList());
                if (closedSolutions.size() >= this.limitSolutions || this.profileQuery && combinedSolution.departureTime != null && (combinedSolution.departureTime - this.initialTime.toEpochMilli()) * (this.arriveBy ? -1L : 1L) > this.maxProfileDuration && closedSolutions.size() > 0 && ((Label)closedSolutions.get((int)(closedSolutions.size() - 1))).departureTime != null && (((Label)closedSolutions.get((int)(closedSolutions.size() - 1))).departureTime - this.initialTime.toEpochMilli()) * (this.arriveBy ? -1L : 1L) > this.maxProfileDuration) continue;
                discoveredSolutions.add(combinedSolution);
                discoveredSolutions.sort(Comparator.comparingLong(s2 -> Optional.ofNullable(s2.departureTime).orElse(0L)));
                originalSolutions.put(combinedSolution, label);
                if (label.nTransfers == 0 && reverseLabel.nTransfers == 0) {
                    accessEgressModeOnlySolution = combinedSolution;
                }
                if (this.profileQuery) {
                    highestWeightForDominationTest = discoveredSolutions.stream().mapToLong(this.router::weight).max().orElse(Long.MAX_VALUE);
                    if (accessEgressModeOnlySolution == null || discoveredSolutions.size() >= this.limitSolutions) continue;
                    highestWeightForDominationTest = Math.max(highestWeightForDominationTest, this.router.weight(accessEgressModeOnlySolution) + this.maxProfileDuration);
                    continue;
                }
                highestWeightForDominationTest = discoveredSolutions.stream().filter(s2 -> !s2.impossible && (this.ignoreTransfers || s2.nTransfers <= 1)).mapToLong(this.router::weight).min().orElse(Long.MAX_VALUE);
            }
            ArrayList<List<Label.Transition>> paths = new ArrayList<List<Label.Transition>>();
            for (Label discoveredSolution : discoveredSolutions) {
                Label originalSolution = (Label)originalSolutions.get(discoveredSolution);
                List<Label.Transition> pathToDestinationStop = Label.getTransitions(originalSolution, this.arriveBy, PtRouterImpl.this.ptEncodedValues, this.queryGraph, PtRouterImpl.this.realtimeFeed);
                if (this.arriveBy) {
                    List<Label.Transition> pathFromStation = Label.getTransitions((Label)reverseSettledSet.get(pathToDestinationStop.get((int)0).label.adjNode), false, PtRouterImpl.this.ptEncodedValues, this.queryGraph, PtRouterImpl.this.realtimeFeed);
                    long diff = pathToDestinationStop.get((int)0).label.currentTime - pathFromStation.get((int)(pathFromStation.size() - 1)).label.currentTime;
                    List patchedPathFromStation = pathFromStation.stream().map(t -> new Label.Transition(new Label(t.label.currentTime + diff, t.label.edge, t.label.adjNode, t.label.nTransfers, t.label.departureTime, t.label.streetTime, t.label.residualDelay, t.label.impossible, null), t.edge)).collect(Collectors.toList());
                    ArrayList<Label.Transition> pp = new ArrayList<Label.Transition>(pathToDestinationStop.subList(1, pathToDestinationStop.size()));
                    pp.addAll(0, patchedPathFromStation);
                    paths.add(pp);
                    continue;
                }
                Label destinationStopLabel = pathToDestinationStop.get((int)(pathToDestinationStop.size() - 1)).label;
                List<Label.Transition> pathFromStation = Label.getTransitions((Label)reverseSettledSet.get(destinationStopLabel.adjNode), true, PtRouterImpl.this.ptEncodedValues, this.queryGraph, PtRouterImpl.this.realtimeFeed);
                long diff = destinationStopLabel.currentTime - pathFromStation.get((int)0).label.currentTime;
                List patchedPathFromStation = pathFromStation.stream().map(t -> new Label.Transition(new Label(t.label.currentTime + diff, t.label.edge, t.label.adjNode, t.label.nTransfers, t.label.departureTime, destinationStopLabel.streetTime + ((Label.Transition)pathFromStation.get((int)0)).label.streetTime, t.label.residualDelay, t.label.impossible, null), t.edge)).collect(Collectors.toList());
                ArrayList<Label.Transition> pp = new ArrayList<Label.Transition>(pathToDestinationStop);
                pp.addAll(patchedPathFromStation.subList(1, pathFromStation.size()));
                paths.add(pp);
            }
            this.response.addDebugInfo("routing:" + stopWatch.stop().getSeconds() + "s");
            if (discoveredSolutions.isEmpty() && this.visitedNodes >= this.maxVisitedNodesForRequest) {
                this.response.addError(new IllegalArgumentException("No path found - maximum number of nodes exceeded: " + this.maxVisitedNodesForRequest));
            }
            this.response.getHints().putObject("visited_nodes.sum", this.visitedNodes);
            this.response.getHints().putObject("visited_nodes.average", this.visitedNodes);
            if (discoveredSolutions.isEmpty()) {
                this.response.addError(new RuntimeException("No route found"));
            }
            return paths;
        }

        private boolean profileFinished(MultiCriteriaLabelSetting router, List<Label> discoveredSolutions, Label walkSolution) {
            return discoveredSolutions.size() >= this.limitSolutions || !discoveredSolutions.isEmpty() && router.departureTimeSinceStartTime(discoveredSolutions.get(discoveredSolutions.size() - 1)) != null && router.departureTimeSinceStartTime(discoveredSolutions.get(discoveredSolutions.size() - 1)) > this.maxProfileDuration || walkSolution != null;
        }
    }

    public static class Factory {
        private final GraphHopperConfig config;
        private final TranslationMap translationMap;
        private final GraphHopperStorage graphHopperStorage;
        private final LocationIndex locationIndex;
        private final GtfsStorage gtfsStorage;
        private final Map<String, Transfers> transfers;

        private Factory(GraphHopperConfig config, TranslationMap translationMap, GraphHopperStorage graphHopperStorage, LocationIndex locationIndex, GtfsStorage gtfsStorage) {
            this.config = config;
            this.translationMap = translationMap;
            this.graphHopperStorage = graphHopperStorage;
            this.locationIndex = locationIndex;
            this.gtfsStorage = gtfsStorage;
            this.transfers = new HashMap<String, Transfers>();
            for (Map.Entry<String, GTFSFeed> entry : this.gtfsStorage.getGtfsFeeds().entrySet()) {
                this.transfers.put(entry.getKey(), new Transfers(entry.getValue()));
            }
        }

        public PtRouter createWith(GtfsRealtime.FeedMessage realtimeFeed) {
            HashMap<String, GtfsRealtime.FeedMessage> realtimeFeeds = new HashMap<String, GtfsRealtime.FeedMessage>();
            realtimeFeeds.put("gtfs_0", realtimeFeed);
            return new PtRouterImpl(this.config, this.translationMap, this.graphHopperStorage, this.locationIndex, this.gtfsStorage, RealtimeFeed.fromProtobuf(this.graphHopperStorage, this.gtfsStorage, this.transfers, realtimeFeeds), new PathDetailsBuilderFactory());
        }

        public PtRouter createWithoutRealtimeFeed() {
            return new PtRouterImpl(this.config, this.translationMap, this.graphHopperStorage, this.locationIndex, this.gtfsStorage, RealtimeFeed.empty(this.gtfsStorage), new PathDetailsBuilderFactory());
        }
    }
}

