/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntIndexedContainer;
import com.graphhopper.coll.GHBitSet;
import com.graphhopper.coll.GHBitSetImpl;
import com.graphhopper.coll.GHTBitSet;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.ev.StringEncodedValue;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.util.AccessFilter;
import com.graphhopper.routing.util.AllCHEdgesIterator;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.GHDirectory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphBuilder;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.GraphStorage;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.storage.MMapDirectory;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.RAMDirectory;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.ArrayUtil;
import com.graphhopper.util.BitUtil;
import com.graphhopper.util.BreadthFirstSearch;
import com.graphhopper.util.CHEdgeExplorer;
import com.graphhopper.util.CHEdgeIterator;
import com.graphhopper.util.CHEdgeIteratorState;
import com.graphhopper.util.DepthFirstSearch;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.DistancePlaneProjection;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.BBox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GHUtility {
    private static final Logger LOGGER = LoggerFactory.getLogger(GHUtility.class);

    public static List<String> getProblems(Graph g2) {
        int nodeIndex;
        ArrayList<String> problems = new ArrayList<String>();
        int nodes = g2.getNodes();
        NodeAccess na = g2.getNodeAccess();
        try {
            EdgeExplorer explorer = g2.createEdgeExplorer();
            for (nodeIndex = 0; nodeIndex < nodes; ++nodeIndex) {
                double lon;
                double lat = na.getLat(nodeIndex);
                if (lat > 90.0 || lat < -90.0) {
                    problems.add("latitude is not within its bounds " + lat);
                }
                if ((lon = na.getLon(nodeIndex)) > 180.0 || lon < -180.0) {
                    problems.add("longitude is not within its bounds " + lon);
                }
                EdgeIterator iter = explorer.setBaseNode(nodeIndex);
                while (iter.next()) {
                    if (iter.getAdjNode() >= nodes) {
                        problems.add("edge of " + nodeIndex + " has a node " + iter.getAdjNode() + " greater or equal to getNodes");
                    }
                    if (iter.getAdjNode() >= 0) continue;
                    problems.add("edge of " + nodeIndex + " has a negative node " + iter.getAdjNode());
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("problem with node " + nodeIndex, ex);
        }
        return problems;
    }

    public static int count(EdgeIterator iter) {
        int counter = 0;
        while (iter.next()) {
            ++counter;
        }
        return counter;
    }

    public static Set<Integer> asSet(int ... values) {
        HashSet<Integer> s2 = new HashSet<Integer>();
        for (int v : values) {
            s2.add(v);
        }
        return s2;
    }

    public static Set<Integer> getNeighbors(EdgeIterator iter) {
        LinkedHashSet<Integer> list = new LinkedHashSet<Integer>();
        while (iter.next()) {
            list.add(iter.getAdjNode());
        }
        return list;
    }

    public static List<Integer> getEdgeIds(EdgeIterator iter) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        while (iter.next()) {
            list.add(iter.getEdge());
        }
        return list;
    }

    public static void printEdgeInfo(Graph g2, FlagEncoder encoder) {
        System.out.println("-- Graph nodes:" + g2.getNodes() + " edges:" + g2.getEdges() + " ---");
        AllEdgesIterator iter = g2.getAllEdges();
        BooleanEncodedValue accessEnc = encoder.getAccessEnc();
        while (iter.next()) {
            String prefix = iter instanceof AllCHEdgesIterator && ((AllCHEdgesIterator)iter).isShortcut() ? "sc" : "  ";
            String fwdStr = iter.get(accessEnc) ? "fwd" : "   ";
            String bwdStr = iter.getReverse(accessEnc) ? "bwd" : "   ";
            System.out.println(prefix + " " + iter + " " + fwdStr + " " + bwdStr + " " + iter.getDistance());
        }
    }

    public static void printGraphForUnitTest(Graph g2, FlagEncoder encoder) {
        GHUtility.printGraphForUnitTest(g2, encoder, new BBox(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
    }

    public static void printGraphForUnitTest(Graph g2, FlagEncoder encoder, BBox bBox) {
        System.out.println("WARNING: printGraphForUnitTest does not pay attention to custom edge speeds at the moment");
        NodeAccess na = g2.getNodeAccess();
        for (int node = 0; node < g2.getNodes(); ++node) {
            if (!bBox.contains(na.getLat(node), na.getLon(node))) continue;
            System.out.printf(Locale.ROOT, "na.setNode(%d, %f, %f);\n", node, na.getLat(node), na.getLon(node));
        }
        AllEdgesIterator iter = g2.getAllEdges();
        while (iter.next()) {
            if (!bBox.contains(na.getLat(iter.getBaseNode()), na.getLon(iter.getBaseNode())) || !bBox.contains(na.getLat(iter.getAdjNode()), na.getLon(iter.getAdjNode()))) continue;
            GHUtility.printUnitTestEdge(encoder, iter);
        }
    }

    private static void printUnitTestEdge(FlagEncoder encoder, EdgeIteratorState edge) {
        BooleanEncodedValue accessEnc = encoder.getAccessEnc();
        boolean fwd = edge.get(accessEnc);
        boolean bwd = edge.getReverse(accessEnc);
        if (!fwd && !bwd) {
            return;
        }
        int from = fwd ? edge.getBaseNode() : edge.getAdjNode();
        int to = fwd ? edge.getAdjNode() : edge.getBaseNode();
        System.out.printf(Locale.ROOT, "graph.edge(%d, %d, %f, %s); // edgeId=%s\n", from, to, edge.getDistance(), fwd && bwd ? "true" : "false", edge.getEdge());
    }

    public static void buildRandomGraph(Graph graph, Random random, int numNodes, double meanDegree, boolean allowLoops, boolean allowZeroDistance, BooleanEncodedValue accessEnc, DecimalEncodedValue speedEnc, Double speed, double pNonZeroLoop, double pBothDir, double pRandomDistanceOffset) {
        if (numNodes < 2 || meanDegree < 1.0) {
            throw new IllegalArgumentException("numNodes must be >= 2, meanDegree >= 1");
        }
        for (int i = 0; i < numNodes; ++i) {
            double lat = 49.4 + random.nextDouble() * 0.01;
            double lon = 9.7 + random.nextDouble() * 0.01;
            graph.getNodeAccess().setNode(i, lat, lon);
        }
        double minDist = Double.MAX_VALUE;
        double maxDist = Double.MIN_VALUE;
        int totalNumEdges = (int)(0.5 * meanDegree * (double)numNodes);
        int numEdges = 0;
        while (numEdges < totalNumEdges) {
            int from = random.nextInt(numNodes);
            int to = random.nextInt(numNodes);
            if (!allowLoops && from == to) continue;
            double distance = GHUtility.getDistance(from, to, graph.getNodeAccess());
            if (from == to && random.nextDouble() < pNonZeroLoop) {
                distance = random.nextDouble() * 1000.0;
            }
            if (!allowZeroDistance) {
                distance = Math.max(0.001, distance);
            }
            if (random.nextDouble() < pRandomDistanceOffset) {
                distance += random.nextDouble() * distance * 0.01;
            }
            minDist = Math.min(minDist, distance);
            maxDist = Math.max(maxDist, distance);
            boolean bothDirections = random.nextDouble() < pBothDir;
            EdgeIteratorState edge = graph.edge(from, to).setDistance(distance).set(accessEnc, true);
            if (bothDirections) {
                edge.setReverse(accessEnc, true);
            }
            double fwdSpeed = 10.0 + random.nextDouble() * 110.0;
            double bwdSpeed = 10.0 + random.nextDouble() * 110.0;
            if (speed != null) {
                fwdSpeed = bwdSpeed = speed.doubleValue();
            }
            edge.set(speedEnc, fwdSpeed);
            if (speedEnc.isStoreTwoDirections()) {
                edge.setReverse(speedEnc, bwdSpeed);
            }
            ++numEdges;
        }
        LOGGER.debug(String.format(Locale.ROOT, "Finished building random graph, nodes: %d, edges: %d , min distance: %.2f, max distance: %.2f\n", graph.getNodes(), graph.getEdges(), minDist, maxDist));
    }

    public static double getDistance(int from, int to, NodeAccess nodeAccess) {
        double fromLat = nodeAccess.getLat(from);
        double fromLon = nodeAccess.getLon(from);
        double toLat = nodeAccess.getLat(to);
        double toLon = nodeAccess.getLon(to);
        return DistancePlaneProjection.DIST_PLANE.calcDist(fromLat, fromLon, toLat, toLon);
    }

    public static void addRandomTurnCosts(Graph graph, long seed, EncodingManager em, FlagEncoder encoder, int maxTurnCost, TurnCostStorage turnCostStorage) {
        Random random = new Random(seed);
        double pNodeHasTurnCosts = 0.3;
        double pEdgePairHasTurnCosts = 0.6;
        double pCostIsRestriction = 0.1;
        DecimalEncodedValue turnCostEnc = em.getDecimalEncodedValue(TurnCost.key(encoder.toString()));
        EdgeExplorer inExplorer = graph.createEdgeExplorer(AccessFilter.inEdges(encoder.getAccessEnc()));
        EdgeExplorer outExplorer = graph.createEdgeExplorer(AccessFilter.outEdges(encoder.getAccessEnc()));
        for (int node = 0; node < graph.getNodes(); ++node) {
            if (!(random.nextDouble() < pNodeHasTurnCosts)) continue;
            EdgeIterator inIter = inExplorer.setBaseNode(node);
            while (inIter.next()) {
                EdgeIterator outIter = outExplorer.setBaseNode(node);
                while (outIter.next()) {
                    if (inIter.getEdge() == outIter.getEdge() || !(random.nextDouble() < pEdgePairHasTurnCosts)) continue;
                    double cost = random.nextDouble() < pCostIsRestriction ? Double.POSITIVE_INFINITY : random.nextDouble() * (double)maxTurnCost;
                    turnCostStorage.set(turnCostEnc, inIter.getEdge(), node, outIter.getEdge(), cost);
                }
            }
        }
    }

    public static List<Snap> createRandomSnaps(BBox bbox, LocationIndex locationIndex, Random rnd, int numPoints, boolean acceptTower, EdgeFilter filter) {
        int maxTries = numPoints * 100;
        int tries = 0;
        ArrayList<Snap> snaps = new ArrayList<Snap>(numPoints);
        while (snaps.size() < numPoints) {
            if (tries > maxTries) {
                throw new IllegalArgumentException("Could not create " + numPoints + " random points. tries: " + tries + ", maxTries: " + maxTries);
            }
            Snap snap = GHUtility.getRandomSnap(locationIndex, rnd, bbox, filter);
            boolean accepted = snap.isValid();
            if (!acceptTower) {
                boolean bl = accepted = accepted && !snap.getSnappedPosition().equals((Object)Snap.Position.TOWER);
            }
            if (accepted) {
                snaps.add(snap);
            }
            ++tries;
        }
        return snaps;
    }

    public static Snap getRandomSnap(LocationIndex locationIndex, Random rnd, BBox bbox, EdgeFilter filter) {
        return locationIndex.findClosest(GHUtility.randomDoubleInRange(rnd, bbox.minLat, bbox.maxLat), GHUtility.randomDoubleInRange(rnd, bbox.minLon, bbox.maxLon), filter);
    }

    public static double randomDoubleInRange(Random rnd, double min2, double max) {
        return min2 + rnd.nextDouble() * (max - min2);
    }

    public static void printInfo(final Graph g2, int startNode, final int counts, final EdgeFilter filter) {
        new BreadthFirstSearch(){
            int counter = 0;

            @Override
            protected GHBitSet createBitSet() {
                return new GHTBitSet();
            }

            @Override
            protected boolean goFurther(int nodeId) {
                System.out.println(GHUtility.getNodeInfo(g2, nodeId, filter));
                return this.counter++ <= counts;
            }
        }.start(g2.createEdgeExplorer(), startNode);
    }

    public static String getNodeInfo(CHGraph g2, int nodeId, EdgeFilter filter) {
        CHEdgeExplorer ex = g2.createEdgeExplorer(filter);
        CHEdgeIterator iter = ex.setBaseNode(nodeId);
        NodeAccess na = g2.getBaseGraph().getNodeAccess();
        String str = nodeId + ":" + na.getLat(nodeId) + "," + na.getLon(nodeId) + "\n";
        while (iter.next()) {
            str = str + "  ->" + iter.getAdjNode() + "(" + iter.getSkippedEdge1() + "," + iter.getSkippedEdge2() + ") " + iter.getEdge() + " \t" + BitUtil.BIG.toBitString(iter.getFlags().ints[0], 8) + "\n";
        }
        return str;
    }

    public static String getNodeInfo(Graph g2, int nodeId, EdgeFilter filter) {
        EdgeIterator iter = g2.createEdgeExplorer(filter).setBaseNode(nodeId);
        NodeAccess na = g2.getNodeAccess();
        String str = nodeId + ":" + na.getLat(nodeId) + "," + na.getLon(nodeId) + "\n";
        while (iter.next()) {
            str = str + "  ->" + iter.getAdjNode() + " (" + iter.getDistance() + ") pillars:" + iter.fetchWayGeometry(FetchMode.PILLAR_ONLY).size() + ", edgeId:" + iter.getEdge() + "\t" + BitUtil.BIG.toBitString(iter.getFlags().ints[0], 8) + "\n";
        }
        return str;
    }

    public static Graph shuffle(Graph g2, Graph sortedGraph) {
        if (g2.getTurnCostStorage() != null) {
            throw new IllegalArgumentException("Shuffling the graph is currently not supported in the presence of turn costs");
        }
        IntArrayList nodes = ArrayUtil.permutation(g2.getNodes(), new Random());
        IntArrayList edges = ArrayUtil.permutation(g2.getEdges(), new Random());
        return GHUtility.createSortedGraph(g2, sortedGraph, nodes, edges);
    }

    public static Graph sortDFS(Graph g2, Graph sortedGraph) {
        if (g2.getTurnCostStorage() != null) {
            throw new IllegalArgumentException("Sorting the graph is currently not supported in the presence of turn costs");
        }
        int nodes = g2.getNodes();
        final IntArrayList nodeList = ArrayUtil.constant(nodes, -1);
        final GHBitSetImpl nodeBitset = new GHBitSetImpl(nodes);
        final AtomicInteger nodeRef = new AtomicInteger(-1);
        int edges = g2.getEdges();
        final IntArrayList edgeList = ArrayUtil.constant(edges, -1);
        final GHBitSetImpl edgeBitset = new GHBitSetImpl(edges);
        final AtomicInteger edgeRef = new AtomicInteger(-1);
        EdgeExplorer explorer = g2.createEdgeExplorer();
        int startNode = 0;
        while (startNode >= 0 && startNode < nodes) {
            new DepthFirstSearch(){

                @Override
                protected GHBitSet createBitSet() {
                    return nodeBitset;
                }

                @Override
                protected boolean checkAdjacent(EdgeIteratorState edge) {
                    int edgeId = edge.getEdge();
                    if (!edgeBitset.contains(edgeId)) {
                        edgeBitset.add(edgeId);
                        edgeList.set(edgeRef.incrementAndGet(), edgeId);
                    }
                    return super.checkAdjacent(edge);
                }

                @Override
                protected boolean goFurther(int nodeId) {
                    nodeList.set(nodeId, nodeRef.incrementAndGet());
                    return super.goFurther(nodeId);
                }
            }.start(explorer, startNode);
            startNode = nodeBitset.nextClear(startNode + 1);
        }
        return GHUtility.createSortedGraph(g2, sortedGraph, nodeList, edgeList);
    }

    static Graph createSortedGraph(Graph fromGraph, Graph toSortedGraph, IntIndexedContainer oldToNewNodeList, IntIndexedContainer newToOldEdgeList) {
        if (fromGraph.getTurnCostStorage() != null) {
            throw new IllegalArgumentException("Sorting the graph is currently not supported in the presence of turn costs");
        }
        int edges = fromGraph.getEdges();
        for (int i = 0; i < edges; ++i) {
            int edgeId = newToOldEdgeList.get(i);
            if (edgeId < 0) continue;
            EdgeIteratorState eIter = fromGraph.getEdgeIteratorState(edgeId, Integer.MIN_VALUE);
            int base = eIter.getBaseNode();
            int newBaseIndex = oldToNewNodeList.get(base);
            int adj = eIter.getAdjNode();
            int newAdjIndex = oldToNewNodeList.get(adj);
            if (newBaseIndex < 0 || newAdjIndex < 0) continue;
            toSortedGraph.edge(newBaseIndex, newAdjIndex).copyPropertiesFrom(eIter);
        }
        int nodes = fromGraph.getNodes();
        NodeAccess na = fromGraph.getNodeAccess();
        NodeAccess sna = toSortedGraph.getNodeAccess();
        for (int old = 0; old < nodes; ++old) {
            int newIndex = oldToNewNodeList.get(old);
            if (sna.is3D()) {
                sna.setNode(newIndex, na.getLat(old), na.getLon(old), na.getEle(old));
                continue;
            }
            sna.setNode(newIndex, na.getLat(old), na.getLon(old));
        }
        return toSortedGraph;
    }

    public static Graph copyTo(Graph fromGraph, Graph toGraph) {
        if (fromGraph.getTurnCostStorage() != null) {
            throw new IllegalArgumentException("Copying a graph is currently not supported in the presence of turn costs");
        }
        AllEdgesIterator eIter = fromGraph.getAllEdges();
        while (eIter.next()) {
            int base = eIter.getBaseNode();
            int adj = eIter.getAdjNode();
            toGraph.edge(base, adj).copyPropertiesFrom(eIter);
        }
        NodeAccess fna = fromGraph.getNodeAccess();
        NodeAccess tna = toGraph.getNodeAccess();
        int nodes = fromGraph.getNodes();
        for (int node = 0; node < nodes; ++node) {
            if (tna.is3D()) {
                tna.setNode(node, fna.getLat(node), fna.getLon(node), fna.getEle(node));
                continue;
            }
            tna.setNode(node, fna.getLat(node), fna.getLon(node));
        }
        return toGraph;
    }

    static Directory guessDirectory(GraphStorage store) {
        if (store.getDirectory() instanceof MMapDirectory) {
            throw new IllegalStateException("not supported yet: mmap will overwrite existing storage at the same location");
        }
        String location = store.getDirectory().getLocation();
        boolean isStoring = ((GHDirectory)store.getDirectory()).isStoring();
        return new RAMDirectory(location, isStoring);
    }

    public static GraphHopperStorage newStorage(GraphHopperStorage store) {
        Directory outdir = GHUtility.guessDirectory(store);
        boolean is3D = store.getNodeAccess().is3D();
        return new GraphBuilder(store.getEncodingManager()).withTurnCosts(store.getTurnCostStorage() != null).set3D(is3D).setDir(outdir).setCHConfigs(store.getCHConfigs()).create();
    }

    public static int getAdjNode(Graph g2, int edge, int adjNode) {
        if (EdgeIterator.Edge.isValid(edge)) {
            EdgeIteratorState iterTo = g2.getEdgeIteratorState(edge, adjNode);
            return iterTo.getAdjNode();
        }
        return adjNode;
    }

    public static EdgeIteratorState createMockedEdgeIteratorState(double distance, IntsRef flags) {
        return GHUtility.createMockedEdgeIteratorState(distance, flags, 0, 1, 2, 3, 4);
    }

    public static EdgeIteratorState createMockedEdgeIteratorState(final double distance, final IntsRef flags, final int base, final int adj, final int edge, final int origFirst, final int origLast) {
        return new DisabledEdgeIterator(){

            @Override
            public double getDistance() {
                return distance;
            }

            @Override
            public IntsRef getFlags() {
                return flags;
            }

            @Override
            public boolean get(BooleanEncodedValue property) {
                return property.getBool(false, flags);
            }

            @Override
            public boolean getReverse(BooleanEncodedValue property) {
                return property.getBool(true, flags);
            }

            @Override
            public double get(DecimalEncodedValue property) {
                return property.getDecimal(false, flags);
            }

            @Override
            public double getReverse(DecimalEncodedValue property) {
                return property.getDecimal(true, flags);
            }

            @Override
            public <T extends Enum<?>> T get(EnumEncodedValue<T> property) {
                return property.getEnum(false, flags);
            }

            @Override
            public <T extends Enum<?>> T getReverse(EnumEncodedValue<T> property) {
                return property.getEnum(true, flags);
            }

            @Override
            public int getEdge() {
                return edge;
            }

            @Override
            public int getBaseNode() {
                return base;
            }

            @Override
            public int getAdjNode() {
                return adj;
            }

            @Override
            public PointList fetchWayGeometry(FetchMode type) {
                return Helper.createPointList(0.0, 2.0, 6.0, 4.0);
            }

            @Override
            public int getOrigEdgeFirst() {
                return origFirst;
            }

            @Override
            public int getOrigEdgeLast() {
                return origLast;
            }
        };
    }

    public static EdgeIteratorState getEdge(Graph graph, int base, int adj) {
        EdgeIterator iter = graph.createEdgeExplorer().setBaseNode(base);
        while (iter.next()) {
            if (iter.getAdjNode() != adj) continue;
            return iter;
        }
        return null;
    }

    public static CHEdgeIteratorState getEdge(CHGraph graph, int base, int adj) {
        CHEdgeIterator iter = graph.createEdgeExplorer().setBaseNode(base);
        while (iter.next()) {
            if (iter.getAdjNode() != adj) continue;
            return iter;
        }
        return null;
    }

    public static int createEdgeKey(int nodeA, int nodeB, int edgeId, boolean reverse) {
        edgeId <<= 1;
        if (reverse) {
            return nodeA >= nodeB ? edgeId : edgeId + 1;
        }
        return nodeA > nodeB ? edgeId + 1 : edgeId;
    }

    public static int createEdgeKey(int edgeId, boolean reverse) {
        return (edgeId << 1) + (reverse ? 1 : 0);
    }

    public static boolean isSameEdgeKeys(int edgeKey1, int edgeKey2) {
        return edgeKey1 / 2 == edgeKey2 / 2;
    }

    public static int reverseEdgeKey(int edgeKey) {
        return edgeKey % 2 == 0 ? edgeKey + 1 : edgeKey - 1;
    }

    public static int getEdgeFromEdgeKey(int edgeKey) {
        return edgeKey / 2;
    }

    public static IntsRef setSpeed(double fwdSpeed, double bwdSpeed, FlagEncoder encoder, IntsRef edgeFlags) {
        if (fwdSpeed < 0.0 || bwdSpeed < 0.0) {
            throw new IllegalArgumentException("Speed must be positive but wasn't! fwdSpeed:" + fwdSpeed + ", bwdSpeed:" + bwdSpeed);
        }
        BooleanEncodedValue accessEnc = encoder.getAccessEnc();
        DecimalEncodedValue avgSpeedEnc = encoder.getAverageSpeedEnc();
        avgSpeedEnc.setDecimal(false, edgeFlags, fwdSpeed);
        if (fwdSpeed > 0.0) {
            accessEnc.setBool(false, edgeFlags, true);
        }
        if (bwdSpeed > 0.0 && (fwdSpeed != bwdSpeed || avgSpeedEnc.isStoreTwoDirections())) {
            if (!avgSpeedEnc.isStoreTwoDirections()) {
                throw new IllegalArgumentException("EncodedValue " + avgSpeedEnc.getName() + " supports only one direction but two different speeds were specified " + fwdSpeed + " " + bwdSpeed);
            }
            avgSpeedEnc.setDecimal(true, edgeFlags, bwdSpeed);
        }
        if (bwdSpeed > 0.0) {
            accessEnc.setBool(true, edgeFlags, true);
        }
        return edgeFlags;
    }

    public static void setSpeed(double fwdSpeed, double bwdSpeed, FlagEncoder encoder, EdgeIteratorState ... edges) {
        GHUtility.setSpeed(fwdSpeed, bwdSpeed, encoder, Arrays.asList(edges));
    }

    public static void setSpeed(double fwdSpeed, double bwdSpeed, FlagEncoder encoder, Collection<EdgeIteratorState> edges) {
        if (fwdSpeed < 0.0 || bwdSpeed < 0.0) {
            throw new IllegalArgumentException("Speed must be positive but wasn't! fwdSpeed:" + fwdSpeed + ", bwdSpeed:" + bwdSpeed);
        }
        BooleanEncodedValue accessEnc = encoder.getAccessEnc();
        DecimalEncodedValue avgSpeedEnc = encoder.getAverageSpeedEnc();
        for (EdgeIteratorState edge : edges) {
            edge.set(avgSpeedEnc, fwdSpeed);
            if (fwdSpeed > 0.0) {
                edge.set(accessEnc, true);
            }
            if (bwdSpeed > 0.0 && (fwdSpeed != bwdSpeed || avgSpeedEnc.isStoreTwoDirections())) {
                if (!avgSpeedEnc.isStoreTwoDirections()) {
                    throw new IllegalArgumentException("EncodedValue " + avgSpeedEnc.getName() + " supports only one direction but two different speeds were specified " + fwdSpeed + " " + bwdSpeed);
                }
                edge.setReverse(avgSpeedEnc, bwdSpeed);
            }
            if (!(bwdSpeed > 0.0)) continue;
            edge.setReverse(accessEnc, true);
        }
    }

    public static EdgeIteratorState setSpeed(double averageSpeed, boolean fwd, boolean bwd, FlagEncoder encoder, EdgeIteratorState edge) {
        if (averageSpeed < 1.0E-4 && (fwd || bwd)) {
            throw new IllegalStateException("Zero speed is only allowed if edge will get inaccessible. Otherwise Weighting can produce inconsistent results");
        }
        BooleanEncodedValue accessEnc = encoder.getAccessEnc();
        DecimalEncodedValue avSpeedEnc = encoder.getAverageSpeedEnc();
        edge.set(accessEnc, fwd, bwd);
        if (fwd) {
            edge.set(avSpeedEnc, averageSpeed);
        }
        if (bwd && avSpeedEnc.isStoreTwoDirections()) {
            edge.setReverse(avSpeedEnc, averageSpeed);
        }
        return edge;
    }

    public static void updateDistancesFor(Graph g2, int node, double lat, double lon) {
        NodeAccess na = g2.getNodeAccess();
        na.setNode(node, lat, lon);
        EdgeIterator iter = g2.createEdgeExplorer().setBaseNode(node);
        while (iter.next()) {
            iter.setDistance(DistanceCalcEarth.DIST_EARTH.calcDistance(iter.fetchWayGeometry(FetchMode.ALL)));
        }
    }

    public static double calcWeightWithTurnWeightWithAccess(Weighting weighting, EdgeIteratorState edgeState, boolean reverse, int prevOrNextEdgeId) {
        BooleanEncodedValue accessEnc = weighting.getFlagEncoder().getAccessEnc();
        if (edgeState.getBaseNode() == edgeState.getAdjNode() ? !edgeState.get(accessEnc) && !edgeState.getReverse(accessEnc) : !reverse && !edgeState.get(accessEnc) || reverse && !edgeState.getReverse(accessEnc)) {
            return Double.POSITIVE_INFINITY;
        }
        return GHUtility.calcWeightWithTurnWeight(weighting, edgeState, reverse, prevOrNextEdgeId);
    }

    public static double calcWeightWithTurnWeight(Weighting weighting, EdgeIteratorState edgeState, boolean reverse, int prevOrNextEdgeId) {
        double edgeWeight = weighting.calcEdgeWeight(edgeState, reverse);
        if (!EdgeIterator.Edge.isValid(prevOrNextEdgeId)) {
            return edgeWeight;
        }
        int origEdgeId = reverse ? edgeState.getOrigEdgeLast() : edgeState.getOrigEdgeFirst();
        double turnWeight = reverse ? weighting.calcTurnWeight(origEdgeId, edgeState.getBaseNode(), prevOrNextEdgeId) : weighting.calcTurnWeight(prevOrNextEdgeId, edgeState.getBaseNode(), origEdgeId);
        return edgeWeight + turnWeight;
    }

    public static long calcMillisWithTurnMillis(Weighting weighting, EdgeIteratorState edgeState, boolean reverse, int prevOrNextEdgeId) {
        long edgeMillis = weighting.calcEdgeMillis(edgeState, reverse);
        if (!EdgeIterator.Edge.isValid(prevOrNextEdgeId)) {
            return edgeMillis;
        }
        int origEdgeId = edgeState.getEdge();
        long turnMillis = reverse ? weighting.calcTurnMillis(origEdgeId, edgeState.getBaseNode(), prevOrNextEdgeId) : weighting.calcTurnMillis(prevOrNextEdgeId, edgeState.getBaseNode(), origEdgeId);
        return edgeMillis + turnMillis;
    }

    public static BBox createBBox(EdgeIteratorState edgeState) {
        PointList towerNodes = edgeState.fetchWayGeometry(FetchMode.TOWER_ONLY);
        int secondIndex = towerNodes.size() == 1 ? 0 : 1;
        return BBox.fromPoints(towerNodes.getLat(0), towerNodes.getLon(0), towerNodes.getLat(secondIndex), towerNodes.getLon(secondIndex));
    }

    public static class DisabledNodeAccess
    implements NodeAccess {
        @Override
        public int getTurnCostIndex(int nodeId) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public void setTurnCostIndex(int nodeId, int additionalValue) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean is3D() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public int getDimension() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public void ensureNode(int nodeId) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public void setNode(int nodeId, double lat, double lon, double ele) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public double getLat(int nodeId) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public double getLon(int nodeId) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public double getEle(int nodeId) {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    public static class DisabledEdgeIterator
    implements EdgeIterator {
        @Override
        public EdgeIterator detach(boolean reverse) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public EdgeIteratorState setDistance(double dist) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public EdgeIteratorState setFlags(IntsRef flags) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public boolean next() {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public int getEdge() {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public int getEdgeKey() {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public int getBaseNode() {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public int getAdjNode() {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public double getDistance() {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public IntsRef getFlags() {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public PointList fetchWayGeometry(FetchMode type) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public EdgeIteratorState setWayGeometry(PointList list) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public EdgeIteratorState setName(String name) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public boolean get(BooleanEncodedValue property) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public EdgeIteratorState set(BooleanEncodedValue property, boolean value) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public boolean getReverse(BooleanEncodedValue property) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public EdgeIteratorState setReverse(BooleanEncodedValue property, boolean value) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public EdgeIteratorState set(BooleanEncodedValue property, boolean fwd, boolean bwd) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public int get(IntEncodedValue property) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public EdgeIteratorState set(IntEncodedValue property, int value) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public int getReverse(IntEncodedValue property) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public EdgeIteratorState setReverse(IntEncodedValue property, int value) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public EdgeIteratorState set(IntEncodedValue property, int fwd, int bwd) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public double get(DecimalEncodedValue property) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public EdgeIteratorState set(DecimalEncodedValue property, double value) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public double getReverse(DecimalEncodedValue property) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public EdgeIteratorState setReverse(DecimalEncodedValue property, double value) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public EdgeIteratorState set(DecimalEncodedValue property, double fwd, double bwd) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public <T extends Enum<?>> T get(EnumEncodedValue<T> property) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public <T extends Enum<?>> EdgeIteratorState set(EnumEncodedValue<T> property, T value) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public <T extends Enum<?>> T getReverse(EnumEncodedValue<T> property) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public <T extends Enum<?>> EdgeIteratorState setReverse(EnumEncodedValue<T> property, T value) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public <T extends Enum<?>> EdgeIteratorState set(EnumEncodedValue<T> property, T fwd, T bwd) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public String get(StringEncodedValue property) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public EdgeIteratorState set(StringEncodedValue property, String value) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public String getReverse(StringEncodedValue property) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public EdgeIteratorState setReverse(StringEncodedValue property, String value) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public EdgeIteratorState set(StringEncodedValue property, String fwd, String bwd) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public EdgeIteratorState copyPropertiesFrom(EdgeIteratorState edge) {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public int getOrigEdgeFirst() {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }

        @Override
        public int getOrigEdgeLast() {
            throw new UnsupportedOperationException("Not supported. Edge is empty.");
        }
    }
}

