/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.routing.ch.ShortcutFilter;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.RoutingCHEdgeExplorer;
import com.graphhopper.storage.RoutingCHEdgeIterator;
import com.graphhopper.storage.RoutingCHEdgeIteratorStateImpl;
import com.graphhopper.util.CHEdgeIteratorState;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;

public class RoutingCHEdgeIteratorImpl
extends RoutingCHEdgeIteratorStateImpl
implements RoutingCHEdgeExplorer,
RoutingCHEdgeIterator {
    private final EdgeExplorer edgeExplorer;
    private final ShortcutFilter shortcutFilter;
    private EdgeIterator edgeIterator;

    public static RoutingCHEdgeIteratorImpl inEdges(EdgeExplorer edgeExplorer, Weighting weighting) {
        return new RoutingCHEdgeIteratorImpl(edgeExplorer, weighting, ShortcutFilter.inEdges());
    }

    public static RoutingCHEdgeIteratorImpl outEdges(EdgeExplorer edgeExplorer, Weighting weighting) {
        return new RoutingCHEdgeIteratorImpl(edgeExplorer, weighting, ShortcutFilter.outEdges());
    }

    public RoutingCHEdgeIteratorImpl(EdgeExplorer edgeExplorer, Weighting weighting, ShortcutFilter shortcutFilter) {
        super(null, weighting);
        this.edgeExplorer = edgeExplorer;
        this.shortcutFilter = shortcutFilter;
    }

    @Override
    EdgeIteratorState edgeState() {
        return this.edgeIterator;
    }

    @Override
    public RoutingCHEdgeIterator setBaseNode(int baseNode) {
        this.edgeIterator = this.edgeExplorer.setBaseNode(baseNode);
        return this;
    }

    @Override
    public boolean next() {
        do {
            boolean hasNext;
            if (hasNext = this.edgeIterator.next()) continue;
            return false;
        } while (!this.hasAccess());
        return true;
    }

    public String toString() {
        return this.edgeIterator.toString();
    }

    private boolean hasAccess() {
        if (this.isShortcut()) {
            return this.shortcutFilter.accept((CHEdgeIteratorState)((Object)this.edgeIterator));
        }
        if (this.edgeIterator.getBaseNode() == this.edgeIterator.getAdjNode()) {
            return this.finiteWeight(false) || this.finiteWeight(true);
        }
        return this.shortcutFilter.fwd && this.finiteWeight(false) || this.shortcutFilter.bwd && this.finiteWeight(true);
    }

    private boolean finiteWeight(boolean reverse) {
        return !Double.isInfinite(this.getOrigEdgeWeight(reverse, false));
    }
}

