/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs.fare;

import com.conveyal.gtfs.model.Fare;
import com.conveyal.gtfs.model.FareRule;
import com.graphhopper.gtfs.fare.Amount;
import com.graphhopper.gtfs.fare.FareAssignment;
import com.graphhopper.gtfs.fare.OriginDestinationRule;
import com.graphhopper.gtfs.fare.RouteRule;
import com.graphhopper.gtfs.fare.SanitizedFareRule;
import com.graphhopper.gtfs.fare.Ticket;
import com.graphhopper.gtfs.fare.TicketPurchase;
import com.graphhopper.gtfs.fare.TicketPurchaseScoreCalculator;
import com.graphhopper.gtfs.fare.Trip;
import com.graphhopper.gtfs.fare.ZoneRule;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Fares {
    public static Optional<Amount> cheapestFare(Map<String, Map<String, Fare>> fares, Trip trip) {
        return Fares.ticketsBruteForce(fares, trip).flatMap(tickets -> tickets.stream().map(ticket -> {
            Fare fare = (Fare)((Map)fares.get(ticket.feed_id)).get(ticket.getFare().fare_id);
            BigDecimal priceOfOneTicket = BigDecimal.valueOf(fare.fare_attribute.price);
            return new Amount(priceOfOneTicket, fare.fare_attribute.currency_type);
        }).collect(Collectors.groupingBy(Amount::getCurrencyType, Collectors.mapping(Amount::getAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add)))).entrySet().stream().findFirst().map(e -> new Amount((BigDecimal)e.getValue(), (String)e.getKey())));
    }

    static Optional<List<Ticket>> ticketsBruteForce(Map<String, Map<String, Fare>> fares, Trip trip) {
        TicketPurchaseScoreCalculator ticketPurchaseScoreCalculator = new TicketPurchaseScoreCalculator();
        return Fares.allShoppingCarts(fares, trip).max(Comparator.comparingDouble(ticketPurchaseScoreCalculator::calculateScore)).map(TicketPurchase::getTickets);
    }

    static Stream<TicketPurchase> allShoppingCarts(Map<String, Map<String, Fare>> fares, Trip trip) {
        List<Trip.Segment> segments = trip.segments;
        List<List<FareAssignment>> result = Fares.allFareAssignments(fares, segments);
        return result.stream().map(TicketPurchase::new);
    }

    private static List<List<FareAssignment>> allFareAssignments(Map<String, Map<String, Fare>> fares, List<Trip.Segment> segments) {
        if (segments.isEmpty()) {
            ArrayList<List<FareAssignment>> emptyList = new ArrayList<List<FareAssignment>>();
            emptyList.add(Collections.emptyList());
            return emptyList;
        }
        ArrayList<List<FareAssignment>> result = new ArrayList<List<FareAssignment>>();
        Trip.Segment segment = segments.get(0);
        List<List<FareAssignment>> tail = Fares.allFareAssignments(fares, segments.subList(1, segments.size()));
        Collection<Fare> possibleFares = Fares.possibleFares(fares.get(segment.feed_id), segment);
        for (Fare fare : possibleFares) {
            for (List<FareAssignment> tailFareAssignments : tail) {
                ArrayList<FareAssignment> fairAssignments = new ArrayList<FareAssignment>(tailFareAssignments);
                FareAssignment fareAssignment = new FareAssignment(segment);
                fareAssignment.setFare(fare);
                fairAssignments.add(0, fareAssignment);
                result.add(fairAssignments);
            }
        }
        return result;
    }

    static Collection<Fare> possibleFares(Map<String, Fare> fares, Trip.Segment segment) {
        return fares.values().stream().filter(fare -> Fares.applies(fare, segment)).collect(Collectors.toList());
    }

    private static boolean applies(Fare fare, Trip.Segment segment) {
        return fare.fare_rules.isEmpty() || Fares.sanitizeFareRules(fare.fare_rules).stream().anyMatch(rule -> rule.appliesTo(segment));
    }

    static List<SanitizedFareRule> sanitizeFareRules(List<FareRule> gtfsFareRules) {
        ArrayList<SanitizedFareRule> result = new ArrayList<SanitizedFareRule>();
        result.addAll(gtfsFareRules.stream().filter(rule -> rule.route_id != null).map(rule -> new RouteRule(rule.route_id)).collect(Collectors.toList()));
        result.addAll(gtfsFareRules.stream().filter(rule -> rule.origin_id != null && rule.destination_id != null).map(rule -> new OriginDestinationRule(rule.origin_id, rule.destination_id)).collect(Collectors.toList()));
        result.add(gtfsFareRules.stream().filter(rule -> rule.contains_id != null).map(rule -> rule.contains_id).collect(Collectors.collectingAndThen(Collectors.toList(), ZoneRule::new)));
        return result;
    }
}

