/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.gzip;

import java.io.IOException;
import java.util.zip.GZIPInputStream;
import javax.annotation.Priority;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;

@Provider
@Priority(value=4000)
public class GZipDecoder
implements ReaderInterceptor {
    @Override
    public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException {
        String contentEncoding;
        if (!context.getHeaders().containsKey("Accept-Encoding")) {
            context.getHeaders().add("Accept-Encoding", "gzip");
        }
        if ((contentEncoding = context.getHeaders().getFirst("Content-Encoding")) != null && (contentEncoding.equals("gzip") || contentEncoding.equals("x-gzip"))) {
            context.setInputStream(new GZIPInputStream(context.getInputStream()));
        }
        return context.proceed();
    }
}

