/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.details;

import com.graphhopper.routing.ev.BikeNetwork;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.FootNetwork;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.util.details.AverageSpeedDetails;
import com.graphhopper.util.details.BooleanDetails;
import com.graphhopper.util.details.DecimalDetails;
import com.graphhopper.util.details.DistanceDetails;
import com.graphhopper.util.details.EdgeIdDetails;
import com.graphhopper.util.details.EdgeKeyDetails;
import com.graphhopper.util.details.EnumDetails;
import com.graphhopper.util.details.IntDetails;
import com.graphhopper.util.details.PathDetailsBuilder;
import com.graphhopper.util.details.StreetNameDetails;
import com.graphhopper.util.details.TimeDetails;
import com.graphhopper.util.details.WeightDetails;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PathDetailsBuilderFactory {
    public List<PathDetailsBuilder> createPathDetailsBuilders(List<String> requestedPathDetails, EncodedValueLookup evl, Weighting weighting) {
        ArrayList<PathDetailsBuilder> builders = new ArrayList<PathDetailsBuilder>();
        if (requestedPathDetails.contains("average_speed")) {
            builders.add(new AverageSpeedDetails(weighting));
        }
        if (requestedPathDetails.contains("street_name")) {
            builders.add(new StreetNameDetails());
        }
        if (requestedPathDetails.contains("edge_id")) {
            builders.add(new EdgeIdDetails());
        }
        if (requestedPathDetails.contains("edge_key")) {
            builders.add(new EdgeKeyDetails());
        }
        if (requestedPathDetails.contains("time")) {
            builders.add(new TimeDetails(weighting));
        }
        if (requestedPathDetails.contains("weight")) {
            builders.add(new WeightDetails(weighting));
        }
        if (requestedPathDetails.contains("distance")) {
            builders.add(new DistanceDetails());
        }
        for (String checkSuffix : requestedPathDetails) {
            if (!checkSuffix.endsWith(EncodingManager.getKey("", "priority")) || !evl.hasEncodedValue(checkSuffix)) continue;
            builders.add(new DecimalDetails(checkSuffix, evl.getDecimalEncodedValue(checkSuffix)));
        }
        for (String key : Arrays.asList("max_speed", "max_width", "max_height", "max_weight", "max_axle_load", "max_length")) {
            if (!requestedPathDetails.contains(key) || !evl.hasEncodedValue(key)) continue;
            builders.add(new DecimalDetails(key, evl.getDecimalEncodedValue(key)));
        }
        for (String key : Arrays.asList("roundabout", "road_class_link", "get_off_bike")) {
            if (!requestedPathDetails.contains(key) || !evl.hasEncodedValue(key)) continue;
            builders.add(new BooleanDetails(key, evl.getBooleanEncodedValue(key)));
        }
        for (String key : Arrays.asList("road_class", "road_environment", "surface", "road_access", BikeNetwork.KEY, FootNetwork.KEY, "toll", "track_type", "hazmat", "hazmat_tunnel", "hazmat_water", "country")) {
            if (!requestedPathDetails.contains(key) || !evl.hasEncodedValue(key)) continue;
            builders.add(new EnumDetails<Enum>(key, evl.getEnumEncodedValue(key, Enum.class)));
        }
        for (String key : Arrays.asList("mtb_rating", "hike_rating", "horse_rating", "lanes")) {
            if (!requestedPathDetails.contains(key) || !evl.hasEncodedValue(key)) continue;
            builders.add(new IntDetails(key, evl.getIntEncodedValue(key)));
        }
        if (requestedPathDetails.size() != builders.size()) {
            throw new IllegalArgumentException("You requested the details " + requestedPathDetails + " but we could only find " + builders);
        }
        return builders;
    }
}

