/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.routing.ch.NodeOrderingProvider;
import com.graphhopper.routing.ch.PrepareEncoder;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.ev.StringEncodedValue;
import com.graphhopper.routing.util.AllCHEdgesIterator;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.DAType;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.Storable;
import com.graphhopper.util.CHEdgeExplorer;
import com.graphhopper.util.CHEdgeIterator;
import com.graphhopper.util.CHEdgeIteratorState;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PointList;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHGraphImpl
implements CHGraph,
Storable<CHGraph> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CHGraphImpl.class);
    private static final double WEIGHT_FACTOR = 1000.0;
    private static final int MAX_WEIGHT_31 = 0x7FFFFFFC;
    private static final double MAX_WEIGHT = 536870.911;
    private static final double MIN_WEIGHT = 0.001;
    final DataAccess shortcuts;
    final DataAccess nodesCH;
    final int scDirMask = PrepareEncoder.getScDirMask();
    private final CHConfig chConfig;
    private final BaseGraph baseGraph;
    private int N_LEVEL;
    private int N_CH_REF;
    private int nodeCHEntryBytes;
    private int E_NODEA;
    private int E_NODEB;
    private int S_WEIGHT;
    private int S_SKIP_EDGE1;
    private int S_SKIP_EDGE2;
    private int S_ORIG_FIRST;
    private int S_ORIG_LAST;
    private int shortcutEntryBytes;
    private int shortcutCount = 0;
    private boolean isReadyForContraction;

    CHGraphImpl(CHConfig chConfig, Directory dir, BaseGraph baseGraph, int segmentSize) {
        if (chConfig.getWeighting() == null) {
            throw new IllegalStateException("Weighting for CHGraph cannot be null");
        }
        this.chConfig = chConfig;
        this.baseGraph = baseGraph;
        String name = chConfig.getName();
        this.nodesCH = dir.find("nodes_ch_" + name, DAType.getPreferredInt(dir.getDefaultType()));
        this.shortcuts = dir.find("shortcuts_" + name, DAType.getPreferredInt(dir.getDefaultType()));
        if (segmentSize >= 0) {
            this.nodesCH.setSegmentSize(segmentSize);
            this.shortcuts.setSegmentSize(segmentSize);
        }
    }

    @Override
    public CHConfig getCHConfig() {
        return this.chConfig;
    }

    @Override
    public boolean isShortcut(int edgeId) {
        assert (this.baseGraph.isFrozen()) : "level graph not yet frozen";
        return edgeId >= this.baseGraph.edgeCount;
    }

    @Override
    public final void setLevel(int nodeIndex, int level) {
        this.checkNodeId(nodeIndex);
        this.nodesCH.setInt((long)nodeIndex * (long)this.nodeCHEntryBytes + (long)this.N_LEVEL, level);
    }

    @Override
    public final int getLevel(int nodeIndex) {
        this.checkNodeId(nodeIndex);
        return this.nodesCH.getInt((long)nodeIndex * (long)this.nodeCHEntryBytes + (long)this.N_LEVEL);
    }

    final void checkNodeId(int nodeId) {
        assert (nodeId < this.baseGraph.getNodes()) : "node " + nodeId + " is invalid. Not in [0," + this.baseGraph.getNodes() + ")";
    }

    @Override
    public int shortcut(int a, int b, int accessFlags, double weight, int skippedEdge1, int skippedEdge2) {
        if (!this.baseGraph.isFrozen()) {
            throw new IllegalStateException("Cannot create shortcut if graph is not yet frozen");
        }
        this.checkNodeId(a);
        this.checkNodeId(b);
        if (this.getLevel(a) >= this.baseGraph.getNodes() || this.getLevel(a) < 0) {
            throw new IllegalArgumentException("Invalid level for node " + a + ": " + this.getLevel(a) + ". Node a must be assigned a valid level before we add shortcuts a->b or a<-b");
        }
        if (a != b && this.getLevel(a) == this.getLevel(b)) {
            throw new IllegalArgumentException("Different nodes must not have the same level, got levels " + this.getLevel(a) + " and " + this.getLevel(b) + " for nodes " + a + " and " + b);
        }
        if (a != b && this.getLevel(a) > this.getLevel(b)) {
            throw new IllegalArgumentException("The level of nodeA must be smaller than the level of nodeB, but got: " + this.getLevel(a) + " and " + this.getLevel(b) + ". When inserting shortcut: " + a + "-" + b);
        }
        if (this.shortcutCount > 0) {
            int prevNodeA = this.getNodeA(this.toPointer(this.shortcutCount + this.baseGraph.edgeCount - 1));
            int prevLevelA = this.getLevel(prevNodeA);
            if (this.getLevel(a) < prevLevelA) {
                throw new IllegalArgumentException("Invalid level for node " + a + ": " + this.getLevel(a) + ". The level must be equal to or larger than the lower level node of the previous shortcut (node: " + prevNodeA + ", level: " + prevLevelA + ")");
            }
        }
        int shortcutId = this.nextShortcutId();
        this.writeShortcut(shortcutId, a, b);
        this.setEdgeRef(a, shortcutId);
        long edgePointer = this.toPointer(shortcutId);
        this.setAccessAndWeight(edgePointer, accessFlags & this.scDirMask, weight);
        this.setSkippedEdges(edgePointer, skippedEdge1, skippedEdge2);
        return shortcutId;
    }

    void setShortcutFlags(long edgePointer, int flags) {
        this.shortcuts.setInt(edgePointer + (long)this.S_WEIGHT, flags);
    }

    int getShortcutFlags(long edgePointer) {
        return this.shortcuts.getInt(edgePointer + (long)this.S_WEIGHT);
    }

    void setShortcutWeight(long edgePointer, double weight) {
        int accessFlags = this.getShortcutFlags(edgePointer) & this.scDirMask;
        this.setAccessAndWeight(edgePointer, accessFlags, weight);
    }

    void setAccessAndWeight(long edgePointer, int accessFlags, double weight) {
        int weightFlags = this.weightToWeightFlags(edgePointer, weight);
        this.setShortcutFlags(edgePointer, weightFlags | accessFlags);
    }

    int weightToWeightFlags(long edgePointer, double weight) {
        if (weight < 0.0) {
            throw new IllegalArgumentException("weight cannot be negative but was " + weight);
        }
        if (weight < 0.001) {
            NodeAccess nodeAccess = this.baseGraph.getNodeAccess();
            int edgeId = -1;
            LOGGER.warn("Setting weights smaller than 0.001 is not allowed in CHGraphImpl#setWeight. You passed: " + weight + " for the edge " + edgeId + " nodeA " + nodeAccess.getLat(this.getNodeA(edgePointer)) + "," + nodeAccess.getLon(this.getNodeA(edgePointer)) + " nodeB " + nodeAccess.getLat(this.getNodeB(edgePointer)) + "," + nodeAccess.getLon(this.getNodeB(edgePointer)));
            weight = 0.001;
        }
        int weightInt = weight > 536870.911 ? 0x7FFFFFFC : (int)Math.round(weight * 1000.0) << 2;
        return weightInt;
    }

    double getShortcutWeight(long edgePointer) {
        long flags32bit = this.getShortcutFlags(edgePointer);
        double weight = (double)(flags32bit >>> 2) / 1000.0;
        if (weight >= 536870.911) {
            return Double.POSITIVE_INFINITY;
        }
        return weight;
    }

    void setSkippedEdges(long edgePointer, int edge1, int edge2) {
        if (EdgeIterator.Edge.isValid(edge1) != EdgeIterator.Edge.isValid(edge2)) {
            throw new IllegalStateException("Skipped edges of a shortcut needs to be both valid or invalid but they were not " + edge1 + ", " + edge2);
        }
        this.shortcuts.setInt(edgePointer + (long)this.S_SKIP_EDGE1, edge1);
        this.shortcuts.setInt(edgePointer + (long)this.S_SKIP_EDGE2, edge2);
    }

    public void setFirstAndLastOrigEdges(long edgePointer, int origFirst, int origLast) {
        if (!this.chConfig.isEdgeBased()) {
            throw new IllegalStateException("Edge-based shortcuts should only be added when CHGraph is edge-based");
        }
        this.shortcuts.setInt(edgePointer + (long)this.S_ORIG_FIRST, origFirst);
        this.shortcuts.setInt(edgePointer + (long)this.S_ORIG_LAST, origLast);
    }

    private long toPointer(int shortcutId) {
        assert (this.isInBounds(shortcutId)) : "shortcutId " + shortcutId + " not in bounds [" + this.baseGraph.edgeCount + ", " + (this.baseGraph.edgeCount + this.shortcutCount) + ")";
        return (long)(shortcutId - this.baseGraph.edgeCount) * (long)this.shortcutEntryBytes;
    }

    private boolean isInBounds(int shortcutId) {
        int tmp = shortcutId - this.baseGraph.edgeCount;
        return tmp < this.shortcutCount && tmp >= 0;
    }

    @Override
    public int shortcutEdgeBased(int a, int b, int accessFlags, double weight, int skippedEdge1, int skippedEdge2, int origFirst, int origLast) {
        if (!this.chConfig.isEdgeBased()) {
            throw new IllegalStateException("Edge-based shortcuts should only be added when CHGraph is edge-based");
        }
        int scId = this.shortcut(a, b, accessFlags, weight, skippedEdge1, skippedEdge2);
        this.setFirstAndLastOrigEdges(this.toPointer(scId), origFirst, origLast);
        return scId;
    }

    protected int nextShortcutId() {
        int nextSC = this.shortcutCount++;
        if (this.shortcutCount < 0) {
            throw new IllegalStateException("too many shortcuts. new shortcut id would be negative. " + this.toString());
        }
        this.shortcuts.ensureCapacity(((long)this.shortcutCount + 1L) * (long)this.shortcutEntryBytes);
        return nextSC + this.baseGraph.edgeCount;
    }

    @Override
    public CHEdgeExplorer createEdgeExplorer() {
        return this.createEdgeExplorer(EdgeFilter.ALL_EDGES);
    }

    @Override
    public CHEdgeExplorer createEdgeExplorer(EdgeFilter filter) {
        return new CHEdgeIteratorImpl(this.baseGraph, filter);
    }

    @Override
    public EdgeExplorer createOriginalEdgeExplorer() {
        return this.createOriginalEdgeExplorer(EdgeFilter.ALL_EDGES);
    }

    @Override
    public EdgeExplorer createOriginalEdgeExplorer(EdgeFilter filter) {
        return this.baseGraph.createEdgeExplorer(filter);
    }

    @Override
    public final CHEdgeIteratorState getEdgeIteratorState(int edgeId, int endNode) {
        CHEdgeIteratorStateImpl edge;
        if (this.isShortcut(edgeId)) {
            if (!this.isInBounds(edgeId)) {
                throw new IllegalStateException("shortcutId " + edgeId + " out of bounds");
            }
        } else if (!this.baseGraph.isInBounds(edgeId)) {
            throw new IllegalStateException("edgeId " + edgeId + " out of bounds");
        }
        if ((edge = new CHEdgeIteratorStateImpl(new BaseGraph.EdgeIteratorStateImpl(this.baseGraph))).init(edgeId, endNode)) {
            return edge;
        }
        return null;
    }

    @Override
    public int getNodes() {
        return this.baseGraph.getNodes();
    }

    @Override
    public int getEdges() {
        return this.baseGraph.getEdges() + this.shortcutCount;
    }

    @Override
    public int getOriginalEdges() {
        return this.baseGraph.getEdges();
    }

    @Override
    public boolean isReadyForContraction() {
        return this.isReadyForContraction;
    }

    @Override
    public int getOtherNode(int edge, int node) {
        if (this.isShortcut(edge)) {
            long edgePointer = this.toPointer(edge);
            int nodeA = this.getNodeA(edgePointer);
            return node == nodeA ? this.getNodeB(edgePointer) : nodeA;
        }
        return this.baseGraph.getOtherNode(edge, node);
    }

    @Override
    public boolean isAdjacentToNode(int edge, int node) {
        if (this.isShortcut(edge)) {
            long edgePointer = this.toPointer(edge);
            return this.getNodeA(edgePointer) == node || this.getNodeB(edgePointer) == node;
        }
        return this.baseGraph.isAdjacentToNode(edge, node);
    }

    void _prepareForContraction() {
        if (this.isReadyForContraction) {
            return;
        }
        long maxCapacity = (long)this.getNodes() * (long)this.nodeCHEntryBytes;
        this.nodesCH.ensureCapacity(maxCapacity);
        for (int node = 0; node < this.getNodes(); ++node) {
            this.setEdgeRef(node, this.baseGraph.getEdgeRef(node));
        }
        this.isReadyForContraction = true;
    }

    private long writeShortcut(int edgeId, int nodeA, int nodeB) {
        if (!EdgeIterator.Edge.isValid(edgeId)) {
            throw new IllegalStateException("Cannot write edge with illegal ID:" + edgeId + "; nodeA:" + nodeA + ", nodeB:" + nodeB);
        }
        long edgePointer = this.toPointer(edgeId);
        this.shortcuts.setInt(edgePointer + (long)this.E_NODEA, nodeA);
        this.shortcuts.setInt(edgePointer + (long)this.E_NODEB, nodeB);
        return edgePointer;
    }

    String toDetailsString() {
        return this.toString() + ", shortcuts:" + Helper.nf(this.shortcutCount) + " (" + Helper.nf(this.shortcuts.getCapacity() / 0x100000L) + "MB), nodesCH:" + Helper.nf(this.getNodes()) + " (" + Helper.nf(this.nodesCH.getCapacity() / 0x100000L) + "MB)";
    }

    @Override
    public AllCHEdgesIterator getAllEdges() {
        return new AllCHEdgesIteratorImpl(this.baseGraph);
    }

    void loadNodesHeader() {
        this.isReadyForContraction = this.nodesCH.getHeader(0) == 1;
    }

    void setNodesHeader() {
        this.nodesCH.setHeader(0, this.isReadyForContraction ? 1 : 0);
    }

    protected int loadEdgesHeader() {
        this.shortcutCount = this.shortcuts.getHeader(0);
        this.shortcutEntryBytes = this.shortcuts.getHeader(4);
        return 3;
    }

    int setEdgesHeader() {
        this.shortcuts.setHeader(0, this.shortcutCount);
        this.shortcuts.setHeader(4, this.shortcutEntryBytes);
        return 3;
    }

    @Override
    public Graph getBaseGraph() {
        return this.baseGraph;
    }

    void initStorage() {
        this.E_NODEA = 0;
        this.E_NODEB = this.E_NODEA + 4;
        this.S_WEIGHT = this.E_NODEB + 4;
        this.S_SKIP_EDGE1 = this.S_WEIGHT + 4;
        this.S_SKIP_EDGE2 = this.S_SKIP_EDGE1 + 4;
        if (this.chConfig.isEdgeBased()) {
            this.S_ORIG_FIRST = this.S_SKIP_EDGE2 + 4;
            this.S_ORIG_LAST = this.S_ORIG_FIRST + 4;
            this.shortcutEntryBytes = this.S_ORIG_LAST + 4;
        } else {
            this.shortcutEntryBytes = this.S_SKIP_EDGE2 + 4;
        }
        this.N_LEVEL = 0;
        this.N_CH_REF = this.N_LEVEL + 4;
        this.nodeCHEntryBytes = this.N_CH_REF + 4;
    }

    @Override
    public CHGraph create(long bytes) {
        this.nodesCH.create(bytes);
        this.shortcuts.create(bytes);
        return this;
    }

    @Override
    public boolean loadExisting() {
        if (!this.nodesCH.loadExisting() || !this.shortcuts.loadExisting()) {
            return false;
        }
        this.loadNodesHeader();
        this.loadEdgesHeader();
        return true;
    }

    @Override
    public void flush() {
        this.setNodesHeader();
        this.setEdgesHeader();
        this.nodesCH.flush();
        this.shortcuts.flush();
    }

    @Override
    public void close() {
        this.nodesCH.close();
        this.shortcuts.close();
    }

    @Override
    public boolean isClosed() {
        return this.nodesCH.isClosed();
    }

    @Override
    public long getCapacity() {
        return this.nodesCH.getCapacity() + this.shortcuts.getCapacity();
    }

    public String toString() {
        return "CHGraph|" + this.chConfig.getName() + "|" + (Object)((Object)this.chConfig.getTraversalMode());
    }

    @Override
    public void debugPrint() {
        int printMax = 100;
        System.out.println("nodesCH:");
        String formatNodes = "%12s | %12s | %12s \n";
        System.out.format(Locale.ROOT, formatNodes, "#", "N_CH_REF", "N_LEVEL");
        for (int i = 0; i < Math.min(this.baseGraph.getNodes(), 100); ++i) {
            System.out.format(Locale.ROOT, formatNodes, i, this.getEdgeRef(i), this.getLevel(i));
        }
        if (this.baseGraph.getNodes() > 100) {
            System.out.format(Locale.ROOT, " ... %d more nodes", this.baseGraph.getNodes() - 100);
        }
        System.out.println("shortcuts:");
        String formatShortcutsBase = "%12s | %12s | %12s | %12s | %12s | %12s";
        String formatShortcutExt = " | %12s | %12s";
        String header = String.format(Locale.ROOT, formatShortcutsBase, "#", "E_NODEA", "E_NODEB", "S_WEIGHT", "S_SKIP_EDGE1", "S_SKIP_EDGE2");
        if (this.chConfig.isEdgeBased()) {
            header = header + String.format(Locale.ROOT, formatShortcutExt, "S_ORIG_FIRST", "S_ORIG_LAST");
        }
        System.out.println(header);
        for (int i = this.baseGraph.edgeCount; i < this.baseGraph.edgeCount + Math.min(this.shortcutCount, 100); ++i) {
            long edgePointer = this.toPointer(i);
            String edgeString = String.format(Locale.ROOT, formatShortcutsBase, i, this.getNodeA(edgePointer), this.getNodeB(edgePointer), this.getShortcutFlags(edgePointer), this.shortcuts.getInt(edgePointer + (long)this.S_SKIP_EDGE1), this.shortcuts.getInt(edgePointer + (long)this.S_SKIP_EDGE2));
            if (this.chConfig.isEdgeBased()) {
                edgeString = edgeString + String.format(Locale.ROOT, formatShortcutExt, this.shortcuts.getInt(edgePointer + (long)this.S_ORIG_FIRST), this.shortcuts.getInt(edgePointer + (long)this.S_ORIG_LAST));
            }
            System.out.println(edgeString);
        }
        if (this.shortcutCount > 100) {
            System.out.printf(Locale.ROOT, " ... %d more shortcut edges\n", this.shortcutCount - 100);
        }
    }

    private int getNodeA(long edgePointer) {
        return this.shortcuts.getInt(edgePointer + (long)this.E_NODEA);
    }

    private int getNodeB(long edgePointer) {
        return this.shortcuts.getInt(edgePointer + (long)this.E_NODEB);
    }

    @Override
    public NodeOrderingProvider getNodeOrderingProvider() {
        int numNodes = this.getNodes();
        int[] nodeOrdering = new int[numNodes];
        int i = 0;
        while (i < numNodes) {
            int level = this.getLevel(i);
            nodeOrdering[level] = i++;
        }
        return NodeOrderingProvider.fromArray(nodeOrdering);
    }

    private int getEdgeRef(int nodeId) {
        return this.nodesCH.getInt((long)nodeId * (long)this.nodeCHEntryBytes + (long)this.N_CH_REF);
    }

    private void setEdgeRef(int nodeId, int edgeId) {
        this.nodesCH.setInt((long)nodeId * (long)this.nodeCHEntryBytes + (long)this.N_CH_REF, edgeId);
    }

    private class CHEdgeIteratorStateImpl
    implements CHEdgeIteratorState {
        final BaseGraph.EdgeIteratorStateImpl edgeIterable;
        long edgePointer = -1L;
        int baseNode;
        int adjNode;
        boolean reverse = false;
        boolean freshFlags;
        int edgeId = -1;
        private int chFlags;

        private CHEdgeIteratorStateImpl(BaseGraph.EdgeIteratorStateImpl edgeIterable) {
            this.edgeIterable = edgeIterable;
        }

        boolean init(int edgeId, int expectedAdjNode) {
            if (edgeId < ((CHGraphImpl)CHGraphImpl.this).baseGraph.edgeCount) {
                boolean b = this.edgeIterable.init(edgeId, expectedAdjNode);
                this.edgeId = this.edgeIterable.edgeId;
                return b;
            }
            if (!EdgeIterator.Edge.isValid(edgeId)) {
                throw new IllegalArgumentException("fetching the edge requires a valid edgeId but was " + edgeId);
            }
            this.edgeId = edgeId;
            this.edgePointer = CHGraphImpl.this.toPointer(edgeId);
            this.baseNode = CHGraphImpl.this.getNodeA(this.edgePointer);
            this.adjNode = CHGraphImpl.this.getNodeB(this.edgePointer);
            this.freshFlags = false;
            if (expectedAdjNode == this.adjNode || expectedAdjNode == Integer.MIN_VALUE) {
                this.reverse = false;
                return true;
            }
            if (expectedAdjNode == this.baseNode) {
                this.reverse = true;
                this.baseNode = this.adjNode;
                this.adjNode = expectedAdjNode;
                return true;
            }
            return false;
        }

        @Override
        public int getBaseNode() {
            return this.edgeId < ((CHGraphImpl)CHGraphImpl.this).baseGraph.edgeCount ? this.edgeIterable.getBaseNode() : this.baseNode;
        }

        @Override
        public int getAdjNode() {
            return this.edgeId < ((CHGraphImpl)CHGraphImpl.this).baseGraph.edgeCount ? this.edgeIterable.getAdjNode() : this.adjNode;
        }

        @Override
        public int getEdge() {
            return this.edgeId < ((CHGraphImpl)CHGraphImpl.this).baseGraph.edgeCount ? this.edgeIterable.getEdge() : this.edgeId;
        }

        @Override
        public int getEdgeKey() {
            this.checkShortcut(false, "getEdgeKey");
            return this.edgeIterable.getEdgeKey();
        }

        @Override
        public EdgeIteratorState setFlags(IntsRef edgeFlags) {
            this.checkShortcut(false, "getFlags");
            return this.edgeIterable.setFlags(edgeFlags);
        }

        @Override
        public final IntsRef getFlags() {
            this.checkShortcut(false, "getFlags");
            return this.edgeIterable.getFlags();
        }

        @Override
        public EdgeIteratorState copyPropertiesFrom(EdgeIteratorState e) {
            this.checkShortcut(false, "copyPropertiesFrom");
            return this.edgeIterable.copyPropertiesFrom(e);
        }

        @Override
        public double getDistance() {
            this.checkShortcut(false, "getDistance");
            return this.edgeIterable.getDistance();
        }

        @Override
        public EdgeIteratorState setDistance(double dist) {
            this.checkShortcut(false, "setDistance");
            return this.edgeIterable.setDistance(dist);
        }

        @Override
        public final CHEdgeIteratorState setSkippedEdges(int edge1, int edge2) {
            this.checkShortcut(true, "setSkippedEdges");
            CHGraphImpl.this.setSkippedEdges(this.edgePointer, edge1, edge2);
            return this;
        }

        @Override
        public final int getSkippedEdge1() {
            this.checkShortcut(true, "getSkippedEdge1");
            return CHGraphImpl.this.shortcuts.getInt(this.edgePointer + (long)CHGraphImpl.this.S_SKIP_EDGE1);
        }

        @Override
        public final int getSkippedEdge2() {
            this.checkShortcut(true, "getSkippedEdge2");
            return CHGraphImpl.this.shortcuts.getInt(this.edgePointer + (long)CHGraphImpl.this.S_SKIP_EDGE2);
        }

        @Override
        public int getOrigEdgeFirst() {
            if (!this.isShortcut() || !CHGraphImpl.this.chConfig.isEdgeBased()) {
                return this.getEdge();
            }
            return CHGraphImpl.this.shortcuts.getInt(this.edgePointer + (long)CHGraphImpl.this.S_ORIG_FIRST);
        }

        @Override
        public int getOrigEdgeLast() {
            if (!this.isShortcut() || !CHGraphImpl.this.chConfig.isEdgeBased()) {
                return this.getEdge();
            }
            return CHGraphImpl.this.shortcuts.getInt(this.edgePointer + (long)CHGraphImpl.this.S_ORIG_LAST);
        }

        @Override
        public boolean isShortcut() {
            return this.edgeId >= ((CHGraphImpl)CHGraphImpl.this).baseGraph.edgeCount;
        }

        @Override
        public boolean getFwdAccess() {
            this.checkShortcut(true, "getFwdAccess");
            return (this.getShortcutFlags() & (this.reverse ? PrepareEncoder.getScBwdDir() : PrepareEncoder.getScFwdDir())) != 0;
        }

        @Override
        public boolean getBwdAccess() {
            this.checkShortcut(true, "getBwdAccess");
            return (this.getShortcutFlags() & (this.reverse ? PrepareEncoder.getScFwdDir() : PrepareEncoder.getScBwdDir())) != 0;
        }

        @Override
        public boolean get(BooleanEncodedValue property) {
            if (this.isShortcut()) {
                return this.getFwdAccess();
            }
            return property.getBool(this.edgeIterable.reverse, this.getFlags());
        }

        @Override
        public boolean getReverse(BooleanEncodedValue property) {
            if (this.isShortcut()) {
                return this.getBwdAccess();
            }
            return property.getBool(!this.edgeIterable.reverse, this.getFlags());
        }

        @Override
        public final CHEdgeIteratorState setWeight(double weight) {
            this.checkShortcut(true, "setWeight");
            CHGraphImpl.this.setShortcutWeight(this.edgePointer, weight);
            return this;
        }

        @Override
        public void setFlagsAndWeight(int flags, double weight) {
            this.checkShortcut(true, "setFlagsAndWeight");
            CHGraphImpl.this.setAccessAndWeight(this.edgePointer, flags, weight);
            this.chFlags = flags;
            this.freshFlags = true;
        }

        @Override
        public final double getWeight() {
            this.checkShortcut(true, "getWeight");
            return CHGraphImpl.this.getShortcutWeight(this.edgePointer);
        }

        void checkShortcut(boolean shouldBeShortcut, String methodName) {
            if (this.isShortcut()) {
                if (!shouldBeShortcut) {
                    throw new IllegalStateException("Cannot call " + methodName + " on shortcut " + this.getEdge());
                }
            } else if (shouldBeShortcut) {
                throw new IllegalStateException("Method " + methodName + " only for shortcuts " + this.getEdge());
            }
        }

        @Override
        public final String getName() {
            this.checkShortcut(false, "getName");
            return this.edgeIterable.getName();
        }

        @Override
        public final EdgeIteratorState setName(String name) {
            this.checkShortcut(false, "setName");
            return this.edgeIterable.setName(name);
        }

        @Override
        public final PointList fetchWayGeometry(FetchMode mode) {
            this.checkShortcut(false, "fetchWayGeometry");
            return this.edgeIterable.fetchWayGeometry(mode);
        }

        @Override
        public final EdgeIteratorState setWayGeometry(PointList list) {
            this.checkShortcut(false, "setWayGeometry");
            return this.edgeIterable.setWayGeometry(list);
        }

        @Override
        public EdgeIteratorState set(BooleanEncodedValue property, boolean value) {
            this.checkShortcut(false, "set(BooleanEncodedValue, boolean)");
            return this.edgeIterable.set(property, value);
        }

        @Override
        public EdgeIteratorState setReverse(BooleanEncodedValue property, boolean value) {
            this.checkShortcut(false, "setReverse(BooleanEncodedValue, boolean)");
            return this.edgeIterable.setReverse(property, value);
        }

        @Override
        public EdgeIteratorState set(BooleanEncodedValue property, boolean fwd, boolean bwd) {
            this.checkShortcut(false, "set(BooleanEncodedValue, boolean, boolean)");
            return this.edgeIterable.set(property, fwd, bwd);
        }

        @Override
        public int get(IntEncodedValue property) {
            this.checkShortcut(false, "get(IntEncodedValue)");
            return this.edgeIterable.get(property);
        }

        @Override
        public EdgeIteratorState set(IntEncodedValue property, int value) {
            this.checkShortcut(false, "set(IntEncodedValue, int)");
            return this.edgeIterable.set(property, value);
        }

        @Override
        public int getReverse(IntEncodedValue property) {
            this.checkShortcut(false, "getReverse(IntEncodedValue)");
            return this.edgeIterable.getReverse(property);
        }

        @Override
        public EdgeIteratorState setReverse(IntEncodedValue property, int value) {
            this.checkShortcut(false, "setReverse(IntEncodedValue, int)");
            return this.edgeIterable.setReverse(property, value);
        }

        @Override
        public EdgeIteratorState set(IntEncodedValue property, int fwd, int bwd) {
            this.checkShortcut(false, "set(IntEncodedValue, int, int)");
            return this.edgeIterable.set(property, fwd, bwd);
        }

        @Override
        public double get(DecimalEncodedValue property) {
            this.checkShortcut(false, "get(DecimalEncodedValue)");
            return this.edgeIterable.get(property);
        }

        @Override
        public EdgeIteratorState set(DecimalEncodedValue property, double value) {
            this.checkShortcut(false, "set(DecimalEncodedValue, double)");
            return this.edgeIterable.set(property, value);
        }

        @Override
        public double getReverse(DecimalEncodedValue property) {
            this.checkShortcut(false, "getReverse(DecimalEncodedValue)");
            return this.edgeIterable.getReverse(property);
        }

        @Override
        public EdgeIteratorState setReverse(DecimalEncodedValue property, double value) {
            this.checkShortcut(false, "setReverse(DecimalEncodedValue, double)");
            return this.edgeIterable.setReverse(property, value);
        }

        @Override
        public EdgeIteratorState set(DecimalEncodedValue property, double fwd, double bwd) {
            this.checkShortcut(false, "set(DecimalEncodedValue, double, double)");
            return this.edgeIterable.set(property, fwd, bwd);
        }

        @Override
        public <T extends Enum<?>> T get(EnumEncodedValue<T> property) {
            this.checkShortcut(false, "get(EnumEncodedValue<T>)");
            return this.edgeIterable.get(property);
        }

        @Override
        public <T extends Enum<?>> EdgeIteratorState set(EnumEncodedValue<T> property, T value) {
            this.checkShortcut(false, "set(EnumEncodedValue<T>, T)");
            return this.edgeIterable.set(property, value);
        }

        @Override
        public <T extends Enum<?>> T getReverse(EnumEncodedValue<T> property) {
            this.checkShortcut(false, "getReverse(EnumEncodedValue<T>)");
            return this.edgeIterable.getReverse(property);
        }

        @Override
        public <T extends Enum<?>> EdgeIteratorState setReverse(EnumEncodedValue<T> property, T value) {
            this.checkShortcut(false, "setReverse(EnumEncodedValue<T>, T)");
            return this.edgeIterable.setReverse(property, value);
        }

        @Override
        public <T extends Enum<?>> EdgeIteratorState set(EnumEncodedValue<T> property, T fwd, T bwd) {
            this.checkShortcut(false, "set(EnumEncodedValue<T>, T, T)");
            return this.edgeIterable.set(property, fwd, bwd);
        }

        @Override
        public String get(StringEncodedValue property) {
            this.checkShortcut(false, "get(StringEncodedValue)");
            return this.edgeIterable.get(property);
        }

        @Override
        public EdgeIteratorState set(StringEncodedValue property, String value) {
            this.checkShortcut(false, "set(StringEncodedValue, String)");
            return this.edgeIterable.set(property, value);
        }

        @Override
        public String getReverse(StringEncodedValue property) {
            this.checkShortcut(false, "getReverse(StringEncodedValue)");
            return this.edgeIterable.getReverse(property);
        }

        @Override
        public EdgeIteratorState setReverse(StringEncodedValue property, String value) {
            this.checkShortcut(false, "setReverse(StringEncodedValue, String)");
            return this.edgeIterable.setReverse(property, value);
        }

        @Override
        public EdgeIteratorState set(StringEncodedValue property, String fwd, String bwd) {
            this.checkShortcut(false, "set(StringEncodedValue, String, String)");
            return this.edgeIterable.set(property, fwd, bwd);
        }

        @Override
        public EdgeIteratorState detach(boolean reverseArg) {
            this.checkShortcut(false, "detach(boolean)");
            return this.edgeIterable.detach(reverseArg);
        }

        int getShortcutFlags() {
            if (!this.freshFlags) {
                this.chFlags = CHGraphImpl.this.getShortcutFlags(this.edgePointer);
                this.freshFlags = true;
            }
            return this.chFlags;
        }
    }

    class AllCHEdgesIteratorImpl
    extends CHEdgeIteratorStateImpl
    implements AllCHEdgesIterator {
        private final BaseGraph.AllEdgeIterator allEdgeIterator;

        public AllCHEdgesIteratorImpl(BaseGraph baseGraph) {
            super(new BaseGraph.AllEdgeIterator(baseGraph));
            this.allEdgeIterator = (BaseGraph.AllEdgeIterator)this.edgeIterable;
        }

        @Override
        public boolean next() {
            ++this.edgeId;
            if (this.edgeId < ((CHGraphImpl)CHGraphImpl.this).baseGraph.edgeCount) {
                this.allEdgeIterator.next();
                return true;
            }
            if (this.edgeId < ((CHGraphImpl)CHGraphImpl.this).baseGraph.edgeCount + CHGraphImpl.this.shortcutCount) {
                this.edgePointer = CHGraphImpl.this.toPointer(this.edgeId);
                this.baseNode = CHGraphImpl.this.getNodeA(this.edgePointer);
                this.adjNode = CHGraphImpl.this.getNodeB(this.edgePointer);
                this.freshFlags = false;
                this.reverse = false;
                return true;
            }
            return false;
        }

        @Override
        public EdgeIteratorState detach(boolean reverseArg) {
            return this.allEdgeIterator.detach(reverseArg);
        }

        @Override
        public int getEdge() {
            return this.edgeId;
        }

        @Override
        public int length() {
            return ((CHGraphImpl)CHGraphImpl.this).baseGraph.edgeCount + CHGraphImpl.this.shortcutCount;
        }

        @Override
        public final boolean isShortcut() {
            return this.edgeId >= ((CHGraphImpl)CHGraphImpl.this).baseGraph.edgeCount;
        }
    }

    class CHEdgeIteratorImpl
    extends CHEdgeIteratorStateImpl
    implements CHEdgeExplorer,
    CHEdgeIterator {
        private final BaseGraph.EdgeIteratorImpl baseIterator;
        private int nextEdgeId;

        public CHEdgeIteratorImpl(BaseGraph baseGraph, EdgeFilter filter) {
            super(new BaseGraph.EdgeIteratorImpl(baseGraph, filter));
            this.baseIterator = (BaseGraph.EdgeIteratorImpl)this.edgeIterable;
        }

        @Override
        public final CHEdgeIterator setBaseNode(int baseNode) {
            assert (this.baseIterator.baseGraph.isFrozen()) : "Traversing CHGraph is only possible if BaseGraph is frozen";
            this.baseIterator.nextEdgeId = this.baseIterator.edgeId = CHGraphImpl.this.baseGraph.getEdgeRef(baseNode);
            this.baseIterator.baseNode = baseNode;
            this.nextEdgeId = this.edgeId = CHGraphImpl.this.getEdgeRef(baseNode);
            return this;
        }

        @Override
        public boolean next() {
            while (EdgeIterator.Edge.isValid(this.nextEdgeId) && this.nextEdgeId >= ((CHGraphImpl)CHGraphImpl.this).baseGraph.edgeCount) {
                this.edgeId = this.nextEdgeId;
                this.edgePointer = CHGraphImpl.this.toPointer(this.edgeId);
                this.baseNode = CHGraphImpl.this.getNodeA(this.edgePointer);
                this.adjNode = CHGraphImpl.this.getNodeB(this.edgePointer);
                this.nextEdgeId = this.edgeId - 1;
                if (this.nextEdgeId < ((CHGraphImpl)CHGraphImpl.this).baseGraph.edgeCount || CHGraphImpl.this.getNodeA(CHGraphImpl.this.toPointer(this.nextEdgeId)) != this.baseNode) {
                    this.nextEdgeId = this.edgeIterable.edgeId;
                }
                this.reverse = false;
                this.freshFlags = false;
                if (!this.baseIterator.filter.accept(this)) continue;
                return true;
            }
            do {
                if (!EdgeIterator.Edge.isValid(this.baseIterator.nextEdgeId)) {
                    return false;
                }
                this.baseIterator.goToNext();
                this.edgeId = this.baseIterator.edgeId;
            } while (!this.baseIterator.filter.accept(this));
            return true;
        }

        public String toString() {
            return this.getEdge() + " " + this.getBaseNode() + "-" + this.getAdjNode();
        }
    }
}

