/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Fare;
import com.graphhopper.gtfs.GtfsStorage;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public interface GtfsStorageI {
    public Map<String, Map<String, Fare>> getFares();

    public Map<GtfsStorage.Validity, Integer> getOperatingDayPatterns();

    public Map<GtfsStorage.FeedIdWithTimezone, Integer> getWritableTimeZones();

    public Map<Integer, GtfsStorage.FeedIdWithTimezone> getTimeZones();

    public Map<Integer, byte[]> getTripDescriptors();

    public Map<Integer, Integer> getStopSequences();

    public Map<String, int[]> getBoardEdgesForTrip();

    public Map<String, int[]> getAlightEdgesForTrip();

    public Map<String, GTFSFeed> getGtfsFeeds();

    public Map<GtfsStorage.FeedIdWithStopId, Integer> getStationNodes();

    public Map<Integer, PlatformDescriptor> getPlatformDescriptorByEdge();

    public static class RouteTypePlatform
    extends PlatformDescriptor {
        int route_type;

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RouteTypePlatform that = (RouteTypePlatform)o;
            return this.route_type == that.route_type;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.route_type);
        }

        public String toString() {
            return "RouteTypePlatform{feed_id='" + this.feed_id + '\'' + ", stop_id='" + this.stop_id + '\'' + ", route_type=" + this.route_type + '}';
        }
    }

    public static class RoutePlatform
    extends PlatformDescriptor {
        String route_id;

        public String toString() {
            return "RoutePlatform{feed_id='" + this.feed_id + '\'' + ", stop_id='" + this.stop_id + '\'' + ", route_id='" + this.route_id + '\'' + '}';
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RoutePlatform that = (RoutePlatform)o;
            return this.route_id.equals(that.route_id);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.route_id);
        }
    }

    public static abstract class PlatformDescriptor
    implements Serializable {
        String feed_id;
        String stop_id;

        public static PlatformDescriptor route(String feed_id, String stop_id, String route_id) {
            RoutePlatform routePlatform = new RoutePlatform();
            routePlatform.feed_id = feed_id;
            routePlatform.stop_id = stop_id;
            routePlatform.route_id = route_id;
            return routePlatform;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformDescriptor that = (PlatformDescriptor)o;
            return Objects.equals(this.feed_id, that.feed_id) && Objects.equals(this.stop_id, that.stop_id);
        }

        public int hashCode() {
            return Objects.hash(this.feed_id, this.stop_id);
        }

        public static RouteTypePlatform routeType(String feed_id, String stop_id, int route_type) {
            RouteTypePlatform routeTypePlatform = new RouteTypePlatform();
            routeTypePlatform.feed_id = feed_id;
            routeTypePlatform.stop_id = stop_id;
            routeTypePlatform.route_type = route_type;
            return routeTypePlatform;
        }
    }
}

