/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.model;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Entity;
import java.io.IOException;

public class Trip
extends Entity {
    private static final long serialVersionUID = -4869384750974542712L;
    public String route_id;
    public String service_id;
    public String trip_id;
    public String trip_headsign;
    public String trip_short_name;
    public int direction_id;
    public String block_id;
    public String shape_id;
    public int bikes_allowed;
    public int wheelchair_accessible;
    public String feed_id;

    public static class Loader
    extends Entity.Loader<Trip> {
        public Loader(GTFSFeed feed) {
            super(feed, "trips");
        }

        @Override
        protected boolean isRequired() {
            return true;
        }

        @Override
        public void loadOneRow() throws IOException {
            Trip t = new Trip();
            t.sourceFileLine = this.row + 1L;
            t.route_id = this.getStringField("route_id", true);
            t.service_id = this.getStringField("service_id", true);
            t.trip_id = this.getStringField("trip_id", true);
            t.trip_headsign = this.getStringField("trip_headsign", false);
            t.trip_short_name = this.getStringField("trip_short_name", false);
            t.direction_id = this.getIntField("direction_id", false, 0, 1);
            t.block_id = this.getStringField("block_id", false);
            t.shape_id = this.getStringField("shape_id", false);
            t.bikes_allowed = this.getIntField("bikes_allowed", false, 0, 2);
            t.wheelchair_accessible = this.getIntField("wheelchair_accessible", false, 0, 2);
            t.feed = this.feed;
            t.feed_id = this.feed.feedId;
            this.feed.trips.put(t.trip_id, t);
            this.getRefField("service_id", true, this.feed.services);
            this.getRefField("route_id", true, this.feed.routes);
        }
    }
}

