/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.CHGraphImpl;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphStorage;
import com.graphhopper.storage.InternalGraphEventListener;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.storage.RoutingCHGraphImpl;
import com.graphhopper.storage.StorableProperties;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import com.graphhopper.util.shapes.BBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class GraphHopperStorage
implements GraphStorage,
Graph {
    private final Directory dir;
    private final EncodingManager encodingManager;
    private final StorableProperties properties;
    private final BaseGraph baseGraph;
    private final Collection<CHGraphImpl> chGraphs;
    private final int segmentSize;

    public GraphHopperStorage(Directory dir, EncodingManager encodingManager, boolean withElevation) {
        this(dir, encodingManager, withElevation, false);
    }

    public GraphHopperStorage(Directory dir, EncodingManager encodingManager, boolean withElevation, boolean withTurnCosts) {
        this(dir, encodingManager, withElevation, withTurnCosts, -1);
    }

    public GraphHopperStorage(Directory dir, EncodingManager encodingManager, boolean withElevation, boolean withTurnCosts, int segmentSize) {
        if (encodingManager == null) {
            throw new IllegalArgumentException("EncodingManager needs to be non-null since 0.7. Create one using EncodingManager.create or EncodingManager.create(flagEncoderFactory, ghLocation)");
        }
        this.encodingManager = encodingManager;
        this.dir = dir;
        this.properties = new StorableProperties(dir);
        this.segmentSize = segmentSize;
        InternalGraphEventListener listener = new InternalGraphEventListener(){

            @Override
            public void initStorage() {
                for (CHGraphImpl cg : GraphHopperStorage.this.chGraphs) {
                    cg.initStorage();
                }
            }

            @Override
            public void freeze() {
                for (CHGraphImpl cg : GraphHopperStorage.this.chGraphs) {
                    cg._prepareForContraction();
                }
            }
        };
        this.baseGraph = new BaseGraph(dir, encodingManager, withElevation, listener, withTurnCosts, segmentSize);
        this.chGraphs = new ArrayList<CHGraphImpl>();
    }

    public GraphHopperStorage addCHGraph(CHConfig chConfig) {
        this.baseGraph.checkNotInitialized();
        if (this.getCHConfigs().contains(chConfig)) {
            throw new IllegalArgumentException("For the given CH profile a CHGraph already exists: '" + chConfig.getName() + "'");
        }
        this.chGraphs.add(new CHGraphImpl(chConfig, this.dir, this.baseGraph, this.segmentSize));
        return this;
    }

    public GraphHopperStorage addCHGraphs(List<CHConfig> chConfigs) {
        for (CHConfig chConfig : chConfigs) {
            this.addCHGraph(chConfig);
        }
        return this;
    }

    public CHGraph getCHGraph() {
        if (this.chGraphs.isEmpty()) {
            throw new IllegalStateException("There is no CHGraph");
        }
        if (this.chGraphs.size() > 1) {
            throw new IllegalStateException("There are multiple CHGraphs, use getCHGraph(CHConfig) to retrieve a specific one");
        }
        return this.chGraphs.iterator().next();
    }

    public CHGraph getCHGraph(String chGraphName) {
        for (CHGraphImpl cg : this.chGraphs) {
            if (!cg.getCHConfig().getName().equals(chGraphName)) continue;
            return cg;
        }
        return null;
    }

    public RoutingCHGraph getRoutingCHGraph() {
        return new RoutingCHGraphImpl(this.getCHGraph());
    }

    public RoutingCHGraph getRoutingCHGraph(String chGraphName) {
        CHGraph chGraph = this.getCHGraph(chGraphName);
        return chGraph == null ? null : new RoutingCHGraphImpl(chGraph);
    }

    public List<String> getCHGraphNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (CHGraphImpl cg : this.chGraphs) {
            result.add(cg.getCHConfig().getName());
        }
        return result;
    }

    public boolean isCHPossible() {
        return !this.chGraphs.isEmpty();
    }

    public List<CHConfig> getCHConfigs() {
        ArrayList<CHConfig> result = new ArrayList<CHConfig>(this.chGraphs.size());
        for (CHGraphImpl chGraph : this.chGraphs) {
            result.add(chGraph.getCHConfig());
        }
        return result;
    }

    public List<CHConfig> getCHConfigs(boolean edgeBased) {
        ArrayList<CHConfig> result = new ArrayList<CHConfig>();
        List<CHConfig> chConfigs = this.getCHConfigs();
        for (CHConfig profile : chConfigs) {
            if (edgeBased != profile.isEdgeBased()) continue;
            result.add(profile);
        }
        return result;
    }

    @Override
    public Directory getDirectory() {
        return this.dir;
    }

    @Override
    public GraphHopperStorage create(long byteCount) {
        this.baseGraph.checkNotInitialized();
        if (this.encodingManager == null) {
            throw new IllegalStateException("EncodingManager can only be null if you call loadExisting");
        }
        this.dir.create();
        long initSize = Math.max(byteCount, 100L);
        this.properties.create(100L);
        this.properties.put("graph.encoded_values", this.encodingManager.toEncodedValuesAsString());
        this.properties.put("graph.flag_encoders", this.encodingManager.toFlagEncodersAsString());
        this.properties.put("graph.byte_order", this.dir.getByteOrder());
        this.properties.put("graph.dimension", this.baseGraph.nodeAccess.getDimension());
        this.properties.putCurrentVersions();
        this.baseGraph.create(initSize);
        for (CHGraphImpl cg : this.chGraphs) {
            cg.create(byteCount);
        }
        List<CHConfig> chConfigs = this.getCHConfigs();
        ArrayList<String> chProfileNames = new ArrayList<String>(chConfigs.size());
        for (CHConfig chConfig : chConfigs) {
            chProfileNames.add(chConfig.getName());
        }
        this.properties.put("graph.ch.profiles", ((Object)chProfileNames).toString());
        return this;
    }

    @Override
    public EncodingManager getEncodingManager() {
        return this.encodingManager;
    }

    @Override
    public StorableProperties getProperties() {
        return this.properties;
    }

    @Override
    public boolean loadExisting() {
        this.baseGraph.checkNotInitialized();
        if (this.properties.loadExisting()) {
            this.properties.checkVersions(false);
            String flagEncodersStr = this.properties.get("graph.flag_encoders");
            if (!this.encodingManager.toFlagEncodersAsString().equalsIgnoreCase(flagEncodersStr)) {
                throw new IllegalStateException("Encoding does not match:\nGraphhopper config: " + this.encodingManager.toFlagEncodersAsString() + "\nGraph: " + flagEncodersStr + "\nChange configuration to match the graph or delete " + this.dir.getLocation());
            }
            String encodedValueStr = this.properties.get("graph.encoded_values");
            if (!this.encodingManager.toEncodedValuesAsString().equalsIgnoreCase(encodedValueStr)) {
                throw new IllegalStateException("Encoded values do not match:\nGraphhopper config: " + this.encodingManager.toEncodedValuesAsString() + "\nGraph: " + encodedValueStr + "\nChange configuration to match the graph or delete " + this.dir.getLocation());
            }
            String byteOrder = this.properties.get("graph.byte_order");
            if (!byteOrder.equalsIgnoreCase("" + this.dir.getByteOrder())) {
                throw new IllegalStateException("Configured graph.byte_order (" + this.dir.getByteOrder() + ") is not equal to loaded " + byteOrder + "");
            }
            String dim = this.properties.get("graph.dimension");
            this.baseGraph.loadExisting(dim);
            this.checkIfConfiguredAndLoadedWeightingsCompatible();
            for (CHGraphImpl cg : this.chGraphs) {
                if (cg.loadExisting()) continue;
                throw new IllegalStateException("Cannot load " + cg);
            }
            return true;
        }
        return false;
    }

    private void checkIfConfiguredAndLoadedWeightingsCompatible() {
        String loadedStr = this.properties.get("graph.ch.profiles");
        List<String> loaded = Helper.parseList(loadedStr);
        List<CHConfig> configured = this.getCHConfigs();
        ArrayList<String> configuredNames = new ArrayList<String>(configured.size());
        for (CHConfig p : configured) {
            configuredNames.add(p.getName());
        }
        for (String configuredName : configuredNames) {
            if (loaded.contains(configuredName)) continue;
            throw new IllegalStateException("Configured CH profile: '" + configuredName + "' is not contained in loaded CH profiles: '" + loadedStr + "'.\nYou configured: " + configuredNames);
        }
    }

    @Override
    public void flush() {
        for (CHGraphImpl cg : this.chGraphs) {
            if (cg.isClosed()) continue;
            cg.flush();
        }
        this.baseGraph.flush();
        this.properties.flush();
    }

    @Override
    public void close() {
        this.properties.close();
        this.baseGraph.close();
        for (CHGraphImpl cg : this.chGraphs) {
            if (cg.isClosed()) continue;
            cg.close();
        }
    }

    @Override
    public boolean isClosed() {
        return this.baseGraph.nodes.isClosed();
    }

    @Override
    public long getCapacity() {
        long cnt = this.baseGraph.getCapacity() + this.properties.getCapacity();
        for (CHGraphImpl cg : this.chGraphs) {
            cnt += cg.getCapacity();
        }
        return cnt;
    }

    public synchronized void freeze() {
        if (!this.baseGraph.isFrozen()) {
            this.baseGraph.freeze();
        }
    }

    boolean isFrozen() {
        return this.baseGraph.isFrozen();
    }

    @Override
    public String toDetailsString() {
        String str = this.baseGraph.toDetailsString();
        for (CHGraphImpl cg : this.chGraphs) {
            str = str + ", " + cg.toDetailsString();
        }
        return str;
    }

    public String toString() {
        return (this.isCHPossible() ? "CH|" : "") + this.encodingManager + "|" + this.getDirectory().getDefaultType() + "|" + this.baseGraph.nodeAccess.getDimension() + "D|" + (this.baseGraph.supportsTurnCosts() ? this.baseGraph.turnCostStorage : "no_turn_cost") + "|" + this.getProperties().versionsToString();
    }

    @Override
    public Graph getBaseGraph() {
        return this.baseGraph;
    }

    @Override
    public int getNodes() {
        return this.baseGraph.getNodes();
    }

    @Override
    public int getEdges() {
        return this.baseGraph.getEdges();
    }

    @Override
    public NodeAccess getNodeAccess() {
        return this.baseGraph.getNodeAccess();
    }

    @Override
    public BBox getBounds() {
        return this.baseGraph.getBounds();
    }

    @Override
    public EdgeIteratorState edge(int a, int b) {
        return this.baseGraph.edge(a, b);
    }

    @Override
    public EdgeIteratorState edge(int a, int b, double distance, boolean bothDirections) {
        return this.baseGraph.edge(a, b, distance, bothDirections);
    }

    @Override
    public EdgeIteratorState getEdgeIteratorState(int edgeId, int adjNode) {
        return this.baseGraph.getEdgeIteratorState(edgeId, adjNode);
    }

    @Override
    public AllEdgesIterator getAllEdges() {
        return this.baseGraph.getAllEdges();
    }

    @Override
    public EdgeExplorer createEdgeExplorer(EdgeFilter filter) {
        return this.baseGraph.createEdgeExplorer(filter);
    }

    @Override
    public Graph copyTo(Graph g2) {
        return this.baseGraph.copyTo(g2);
    }

    @Override
    public TurnCostStorage getTurnCostStorage() {
        return this.baseGraph.getTurnCostStorage();
    }

    @Override
    public Weighting wrapWeighting(Weighting weighting) {
        return weighting;
    }

    @Override
    public int getOtherNode(int edge, int node) {
        return this.baseGraph.getOtherNode(edge, node);
    }

    @Override
    public boolean isAdjacentToNode(int edge, int node) {
        return this.baseGraph.isAdjacentToNode(edge, node);
    }

    public void flushAndCloseEarly() {
        this.baseGraph.flushAndCloseGeometryAndNameStorage();
    }
}

