/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting.custom;

import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.util.CustomModel;
import com.graphhopper.routing.weighting.custom.BooleanToValueEntry;
import com.graphhopper.routing.weighting.custom.DecimalToValueEntry;
import com.graphhopper.routing.weighting.custom.EdgeToValueEntry;
import com.graphhopper.routing.weighting.custom.EnumToValueEntry;
import com.graphhopper.routing.weighting.custom.GeoToValueEntry;
import com.graphhopper.routing.weighting.custom.IntToValueEntry;
import com.graphhopper.util.EdgeIteratorState;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;

final class PriorityCalculator {
    private final List<EdgeToValueEntry> priorityList = new ArrayList<EdgeToValueEntry>();

    public PriorityCalculator(CustomModel customModel, EncodedValueLookup lookup) {
        for (Map.Entry<String, Object> entry : customModel.getPriority().entrySet()) {
            String key = entry.getKey();
            String priorityKey = "priority." + key;
            Object value = entry.getValue();
            if (value == null) {
                throw new IllegalArgumentException("Missing value for " + key + " in 'priority'");
            }
            if (key.startsWith("area_")) {
                if (!(value instanceof Number)) {
                    throw new IllegalArgumentException(priorityKey + ": area entry requires number value but was: " + value.getClass().getSimpleName());
                }
                Geometry geometry = GeoToValueEntry.pickGeometry(customModel, key);
                this.priorityList.add(GeoToValueEntry.create(priorityKey, new PreparedGeometryFactory().create(geometry), (Number)value, 1.0, 0.0, 1.0));
                continue;
            }
            if (!(value instanceof Map)) {
                throw new IllegalArgumentException(priorityKey + ": non-root entries require a map but was: " + value.getClass().getSimpleName());
            }
            double defaultPriority = 1.0;
            double minPriority = 0.0;
            double maxPriority = 1.0;
            EncodedValue encodedValue = PriorityCalculator.getEV(lookup, "priority", key);
            if (encodedValue instanceof EnumEncodedValue) {
                this.priorityList.add(EnumToValueEntry.create(priorityKey, (EnumEncodedValue)encodedValue, (Map)value, 1.0, 0.0, 1.0));
                continue;
            }
            if (encodedValue instanceof DecimalEncodedValue) {
                this.priorityList.add(DecimalToValueEntry.create(priorityKey, (DecimalEncodedValue)encodedValue, (Map)value, 1.0, 0.0, 1.0));
                continue;
            }
            if (encodedValue instanceof BooleanEncodedValue) {
                this.priorityList.add(BooleanToValueEntry.create(priorityKey, (BooleanEncodedValue)encodedValue, (Map)value, 1.0, 0.0, 1.0));
                continue;
            }
            if (encodedValue instanceof IntEncodedValue) {
                this.priorityList.add(IntToValueEntry.create(priorityKey, (IntEncodedValue)encodedValue, (Map)value, 1.0, 0.0, 1.0));
                continue;
            }
            throw new IllegalArgumentException("The encoded value '" + key + "' used in 'priority' is of type " + encodedValue.getClass().getSimpleName() + ", but only types enum, decimal and boolean are supported.");
        }
    }

    static EncodedValue getEV(EncodedValueLookup lookup, String name, String key) {
        if (!lookup.hasEncodedValue(key)) {
            throw new IllegalArgumentException("Cannot find encoded value '" + key + "' specified in '" + name + "'. Available: " + PriorityCalculator.names(lookup.getAllShared()));
        }
        return lookup.getEncodedValue(key, EncodedValue.class);
    }

    private static String names(List<EncodedValue> allShared) {
        String nameStr = "";
        for (EncodedValue ev : allShared) {
            nameStr = nameStr + ev.getName() + ",";
        }
        return nameStr;
    }

    public double calcPriority(EdgeIteratorState edge, boolean reverse) {
        double priority = 1.0;
        for (int i = 0; i < this.priorityList.size(); ++i) {
            EdgeToValueEntry entry = this.priorityList.get(i);
            double value = entry.getValue(edge, reverse);
            if (value == 0.0) {
                return 0.0;
            }
            priority *= value;
        }
        return priority;
    }
}

