/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting.custom;

import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.weighting.custom.EdgeToValueEntry;
import com.graphhopper.routing.weighting.custom.EnumToValueEntry;
import com.graphhopper.util.EdgeIteratorState;
import java.util.ArrayList;
import java.util.Map;

final class DecimalToValueEntry
implements EdgeToValueEntry {
    private final DecimalEncodedValue dev;
    private final double minExclusive;
    private final double maxExclusive;
    private final double rangeValue;
    private final double fallback;

    private DecimalToValueEntry(DecimalEncodedValue dev, Range range, double fallback) {
        this.dev = dev;
        this.minExclusive = range.min;
        this.maxExclusive = range.max;
        this.rangeValue = range.value;
        this.fallback = fallback;
    }

    @Override
    public double getValue(EdgeIteratorState iter, boolean reverse) {
        double edgeValue = reverse ? iter.getReverse(this.dev) : iter.get(this.dev);
        return edgeValue < this.maxExclusive && edgeValue > this.minExclusive ? this.rangeValue : this.fallback;
    }

    static EdgeToValueEntry create(String name, DecimalEncodedValue dev, Map<String, Object> map, double defaultValue, double minValue, double maxValue) {
        if (map.isEmpty()) {
            throw new IllegalArgumentException("Empty map for " + name);
        }
        Object evEntryValue = map.get("*");
        if (evEntryValue != null) {
            defaultValue = EnumToValueEntry.getReturnValue(name, "*", evEntryValue, minValue, maxValue);
        }
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (Map.Entry<String, Object> encValEntry : map.entrySet()) {
            if (encValEntry.getKey() == null) {
                throw new IllegalArgumentException("key for " + name + " cannot be null, value: " + encValEntry.getValue());
            }
            String key = encValEntry.getKey();
            if ("*".equals(key)) continue;
            double returnValue = EnumToValueEntry.getReturnValue(name, key, encValEntry.getValue(), minValue, maxValue);
            Range range = DecimalToValueEntry.parseRange(name, key, returnValue);
            ranges.add(range);
        }
        if (ranges.size() != 1) {
            throw new IllegalArgumentException("Currently only one range can be specified but was " + ranges.size());
        }
        return new DecimalToValueEntry(dev, (Range)ranges.get(0), defaultValue);
    }

    static Range parseRange(String name, String rangeAsString, Object value) {
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException(name + " value has to be a number but was " + value);
        }
        double num = ((Number)value).doubleValue();
        try {
            int gtIndex = rangeAsString.indexOf(">");
            if (gtIndex >= 0) {
                return new Range(Double.parseDouble(rangeAsString.substring(gtIndex + 1)), Double.POSITIVE_INFINITY, num);
            }
            int ltIndex = rangeAsString.indexOf("<");
            if (ltIndex >= 0) {
                return new Range(0.0, Double.parseDouble(rangeAsString.substring(ltIndex + 1)), num);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalArgumentException("Range is invalid. It must be e.g. \">3\" or \"<5\" but was: " + rangeAsString);
    }

    public String toString() {
        return this.dev.getName() + ", range: min:" + this.minExclusive + ", max:" + this.maxExclusive + ", value:" + this.rangeValue;
    }

    static class Range {
        final double min;
        final double max;
        final double value;

        public Range(double min2, double max, double value) {
            this.min = min2;
            this.max = max;
            this.value = value;
            if (max < min2) {
                throw new IllegalArgumentException("Wrong range. Minimum " + min2 + " cannot be bigger than maximum " + max);
            }
        }

        public String toString() {
            return "min=" + this.min + ", max=" + this.max + ", value=" + this.value;
        }
    }
}

