/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import java.util.Arrays;

class SplitArray2D<T> {
    private static final int GROW_FACTOR = 2;
    private final int initialSubArrayCapacity;
    private final Object[][] data;
    private final int[] mids;
    private final int[] sizes;

    SplitArray2D(int size, int initialSubArrayCapacity) {
        this.data = new Object[size][];
        this.sizes = new int[size];
        this.mids = new int[size];
        this.initialSubArrayCapacity = initialSubArrayCapacity;
    }

    int mid(int n) {
        return this.mids[n];
    }

    int size(int n) {
        return this.sizes[n];
    }

    T get(int n, int index) {
        return (T)this.data[n][index];
    }

    void addPartOne(int n, T element) {
        if (this.data[n] == null) {
            this.data[n] = new Object[this.initialSubArrayCapacity];
            this.data[n][0] = element;
            this.mids[n] = 1;
            this.sizes[n] = 1;
        } else {
            assert (this.data[n].length != 0);
            if (this.sizes[n] == this.data[n].length) {
                this.grow(n);
            }
            this.data[n][this.sizes[n]] = this.data[n][this.mids[n]];
            this.data[n][this.mids[n]] = element;
            int n2 = n;
            this.mids[n2] = this.mids[n2] + 1;
            int n3 = n;
            this.sizes[n3] = this.sizes[n3] + 1;
        }
    }

    void addPartTwo(int n, T element) {
        if (this.data[n] == null) {
            this.data[n] = new Object[this.initialSubArrayCapacity];
            this.data[n][0] = element;
            this.sizes[n] = 1;
        } else {
            assert (this.data[n].length != 0);
            if (this.sizes[n] == this.data[n].length) {
                this.grow(n);
            }
            this.data[n][this.sizes[n]] = element;
            int n2 = n;
            this.sizes[n2] = this.sizes[n2] + 1;
        }
    }

    void remove(int n, T element) {
        int i;
        for (i = 0; i < this.mids[n]; ++i) {
            while (this.mids[n] > 0 && i < this.mids[n] && this.data[n][i] == element) {
                this.data[n][i] = this.data[n][this.mids[n] - 1];
                this.data[n][this.mids[n] - 1] = this.data[n][this.sizes[n] - 1];
                this.data[n][this.sizes[n] - 1] = null;
                int n2 = n;
                this.mids[n2] = this.mids[n2] - 1;
                int n3 = n;
                this.sizes[n3] = this.sizes[n3] - 1;
            }
        }
        for (i = this.mids[n]; i < this.sizes[n]; ++i) {
            while (this.sizes[n] > this.mids[n] && i < this.sizes[n] && this.data[n][i] == element) {
                this.data[n][i] = this.data[n][this.sizes[n] - 1];
                this.data[n][this.sizes[n] - 1] = null;
                int n4 = n;
                this.sizes[n4] = this.sizes[n4] - 1;
            }
        }
    }

    void clear(int n) {
        this.data[n] = null;
        this.sizes[n] = 0;
        this.mids[n] = 0;
    }

    private void grow(int n) {
        this.data[n] = Arrays.copyOf(this.data[n], this.data[n].length * 2);
    }

    void trimToSize() {
        for (int n = 0; n < this.data.length; ++n) {
            if (this.data[n] == null) continue;
            this.data[n] = Arrays.copyOf(this.data[n], this.sizes[n]);
        }
    }
}

