/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.graphhopper.routing.BidirPathExtractor;
import com.graphhopper.routing.SPTEntry;
import com.graphhopper.routing.ch.CHEntry;
import com.graphhopper.routing.ch.ShortcutUnpacker;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;

public class EdgeBasedCHBidirPathExtractor
extends BidirPathExtractor {
    private final RoutingCHGraph routingGraph;
    private final ShortcutUnpacker shortcutUnpacker;
    private final Weighting weighting;

    public EdgeBasedCHBidirPathExtractor(RoutingCHGraph routingGraph) {
        super(routingGraph.getBaseGraph(), null);
        this.routingGraph = routingGraph;
        this.shortcutUnpacker = this.createShortcutUnpacker();
        this.weighting = routingGraph.getBaseGraph().wrapWeighting(routingGraph.getWeighting());
    }

    @Override
    public void onEdge(int edge, int adjNode, boolean reverse, int prevOrNextEdge) {
        if (reverse) {
            this.shortcutUnpacker.visitOriginalEdgesBwd(edge, adjNode, true, prevOrNextEdge);
        } else {
            this.shortcutUnpacker.visitOriginalEdgesFwd(edge, adjNode, true, prevOrNextEdge);
        }
    }

    @Override
    protected void onMeetingPoint(int inEdge, int viaNode, int outEdge) {
        if (!EdgeIterator.Edge.isValid(inEdge) || !EdgeIterator.Edge.isValid(outEdge)) {
            return;
        }
        this.path.addTime(this.weighting.calcTurnMillis(inEdge, viaNode, outEdge));
    }

    private ShortcutUnpacker createShortcutUnpacker() {
        return new ShortcutUnpacker(this.routingGraph, new ShortcutUnpacker.Visitor(){

            @Override
            public void visit(EdgeIteratorState edge, boolean reverse, int prevOrNextEdgeId) {
                EdgeBasedCHBidirPathExtractor.this.path.addDistance(edge.getDistance());
                EdgeBasedCHBidirPathExtractor.this.path.addTime(GHUtility.calcMillisWithTurnMillis(EdgeBasedCHBidirPathExtractor.this.weighting, edge, reverse, prevOrNextEdgeId));
                EdgeBasedCHBidirPathExtractor.this.path.addEdge(edge.getEdge());
            }
        }, true);
    }

    @Override
    public int getIncEdge(SPTEntry sptEntry) {
        return ((CHEntry)sptEntry).incEdge;
    }
}

