/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.isochrone.algorithm;

import com.graphhopper.isochrone.algorithm.ReadableTriangulation;
import com.graphhopper.isochrone.algorithm.ShortestPathTree;
import com.graphhopper.isochrone.algorithm.Triangulator;
import com.graphhopper.routing.RouterConfig;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.PointList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.triangulate.ConformingDelaunayTriangulator;
import org.locationtech.jts.triangulate.ConstraintVertex;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeSubdivision;
import org.locationtech.jts.triangulate.quadedge.Vertex;

public class JTSTriangulator
implements Triangulator {
    private final RouterConfig routerConfig;

    public JTSTriangulator(RouterConfig routerConfig) {
        this.routerConfig = routerConfig;
    }

    @Override
    public Triangulator.Result triangulate(Snap snap, QueryGraph queryGraph, ShortestPathTree shortestPathTree, ToDoubleFunction<ShortestPathTree.IsoLabel> fz) {
        NodeAccess na = queryGraph.getNodeAccess();
        ArrayList sites = new ArrayList();
        shortestPathTree.search(snap.getClosestNode(), label -> {
            EdgeIteratorState edge;
            PointList innerPoints;
            double exploreValue = fz.applyAsDouble((ShortestPathTree.IsoLabel)label);
            double lat = na.getLatitude(label.node);
            double lon = na.getLongitude(label.node);
            Coordinate site = new Coordinate(lon, lat);
            site.z = exploreValue;
            sites.add(site);
            if (label.parent != null && (innerPoints = (edge = queryGraph.getEdgeIteratorState(label.edge, label.node)).fetchWayGeometry(FetchMode.PILLAR_ONLY)).getSize() > 0) {
                int midIndex = innerPoints.getSize() / 2;
                double lat2 = innerPoints.getLat(midIndex);
                double lon2 = innerPoints.getLon(midIndex);
                Coordinate site2 = new Coordinate(lon2, lat2);
                site2.z = exploreValue;
                sites.add(site2);
            }
        });
        if (sites.size() > this.routerConfig.getMaxVisitedNodes() / 3) {
            throw new IllegalArgumentException("Too many nodes would be included in post processing (" + sites.size() + "). Let us know if you need this increased.");
        }
        Collection constraintVertices = sites.stream().map(ConstraintVertex::new).collect(Collectors.toList());
        ConformingDelaunayTriangulator conformingDelaunayTriangulator = new ConformingDelaunayTriangulator(constraintVertices, 0.0);
        conformingDelaunayTriangulator.setConstraints(new ArrayList(), new ArrayList());
        conformingDelaunayTriangulator.formInitialDelaunay();
        conformingDelaunayTriangulator.enforceConstraints();
        Geometry convexHull = conformingDelaunayTriangulator.getConvexHull();
        if (!(convexHull instanceof Polygon)) {
            throw new IllegalArgumentException("Too few points found. Please try a different 'point' or a larger 'time_limit'.");
        }
        QuadEdgeSubdivision tin = conformingDelaunayTriangulator.getSubdivision();
        for (Vertex vertex : tin.getVertices(true)) {
            if (!tin.isFrameVertex(vertex)) continue;
            vertex.setZ(Double.MAX_VALUE);
        }
        ReadableTriangulation triangulation = ReadableTriangulation.wrap(tin);
        return new Triangulator.Result(triangulation, triangulation.getEdges());
    }
}

