/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.http;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.graphhopper.GraphHopper;
import com.graphhopper.GraphHopperAPI;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.gtfs.GraphHopperGtfs;
import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.PtRouter;
import com.graphhopper.gtfs.PtRouterImpl;
import com.graphhopper.http.GHJerseyViolationExceptionMapper;
import com.graphhopper.http.GraphHopperBundleConfiguration;
import com.graphhopper.http.GraphHopperManaged;
import com.graphhopper.http.IllegalArgumentExceptionMapper;
import com.graphhopper.http.MultiExceptionGPXMessageBodyWriter;
import com.graphhopper.http.MultiExceptionMapper;
import com.graphhopper.http.PtRedirectFilter;
import com.graphhopper.http.TypeGPXFilter;
import com.graphhopper.http.health.GraphHopperHealthCheck;
import com.graphhopper.isochrone.algorithm.JTSTriangulator;
import com.graphhopper.isochrone.algorithm.Triangulator;
import com.graphhopper.jackson.GraphHopperConfigModule;
import com.graphhopper.jackson.Jackson;
import com.graphhopper.resources.CustomWeightingRouteResource;
import com.graphhopper.resources.I18NResource;
import com.graphhopper.resources.InfoResource;
import com.graphhopper.resources.IsochroneResource;
import com.graphhopper.resources.MVTResource;
import com.graphhopper.resources.NearestResource;
import com.graphhopper.resources.PtIsochroneResource;
import com.graphhopper.resources.PtRouteResource;
import com.graphhopper.resources.RouteResource;
import com.graphhopper.resources.SPTResource;
import com.graphhopper.routing.ProfileResolver;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.util.TranslationMap;
import com.graphhopper.util.details.PathDetailsBuilderFactory;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import javax.inject.Inject;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.utilities.binding.AbstractBinder;

public class GraphHopperBundle
implements ConfiguredBundle<GraphHopperBundleConfiguration> {
    @Override
    public void initialize(Bootstrap<?> bootstrap) {
        bootstrap.setObjectMapper(io.dropwizard.jackson.Jackson.newMinimalObjectMapper());
        bootstrap.getObjectMapper().registerModule(new Jdk8Module());
        Jackson.initObjectMapper(bootstrap.getObjectMapper());
        bootstrap.getObjectMapper().registerModule(new GraphHopperConfigModule());
        bootstrap.getObjectMapper().setDateFormat(new StdDateFormat());
        bootstrap.getObjectMapper().enable(MapperFeature.ALLOW_EXPLICIT_PROPERTY_RENAMING);
    }

    @Override
    public void run(final GraphHopperBundleConfiguration configuration, Environment environment) {
        for (Object k : System.getProperties().keySet()) {
            if (!(k instanceof String) || !((String)k).startsWith("graphhopper.")) continue;
            throw new IllegalArgumentException("You need to prefix system parameters with '-Ddw.graphhopper.' instead of '-Dgraphhopper.' see #1879 and #1897");
        }
        environment.jersey().register(new GHJerseyViolationExceptionMapper());
        environment.jersey().register(new TypeGPXFilter());
        environment.jersey().register(new MultiExceptionMapper());
        environment.jersey().register(new MultiExceptionGPXMessageBodyWriter());
        environment.jersey().register(new IllegalArgumentExceptionMapper());
        GraphHopperManaged graphHopperManaged = new GraphHopperManaged(configuration.getGraphHopperConfiguration(), environment.getObjectMapper());
        environment.lifecycle().manage(graphHopperManaged);
        final GraphHopper graphHopper = graphHopperManaged.getGraphHopper();
        environment.jersey().register(new AbstractBinder(){

            @Override
            protected void configure() {
                this.bind(configuration.getGraphHopperConfiguration()).to(GraphHopperConfig.class);
                this.bind(graphHopper).to(GraphHopper.class);
                this.bind(graphHopper).to(GraphHopperAPI.class);
                this.bind(new JTSTriangulator(graphHopper.getRouterConfig())).to(Triangulator.class);
                this.bindFactory(PathDetailsBuilderFactoryFactory.class).to(PathDetailsBuilderFactory.class);
                this.bindFactory(ProfileResolverFactory.class).to(ProfileResolver.class);
                this.bindFactory(HasElevation.class).to(Boolean.class).named("hasElevation");
                this.bindFactory(LocationIndexFactory.class).to(LocationIndex.class);
                this.bindFactory(TranslationMapFactory.class).to(TranslationMap.class);
                this.bindFactory(EncodingManagerFactory.class).to(EncodingManager.class);
                this.bindFactory(GraphHopperStorageFactory.class).to(GraphHopperStorage.class);
                this.bindFactory(GtfsStorageFactory.class).to(GtfsStorage.class);
            }
        });
        environment.jersey().register(MVTResource.class);
        environment.jersey().register(NearestResource.class);
        environment.jersey().register(RouteResource.class);
        environment.jersey().register(CustomWeightingRouteResource.class);
        environment.jersey().register(IsochroneResource.class);
        if (configuration.getGraphHopperConfiguration().has("gtfs.file")) {
            environment.jersey().register(new AbstractBinder(){

                @Override
                protected void configure() {
                    this.bind(PtRouterImpl.class).to(PtRouter.class);
                }
            });
            environment.jersey().register(PtRouteResource.class);
            environment.jersey().register(PtIsochroneResource.class);
            environment.jersey().register(PtRedirectFilter.class);
        }
        environment.jersey().register(SPTResource.class);
        environment.jersey().register(I18NResource.class);
        environment.jersey().register(InfoResource.class);
        environment.healthChecks().register("graphhopper", new GraphHopperHealthCheck(graphHopper));
    }

    static class HasElevation
    implements Factory<Boolean> {
        @Inject
        GraphHopper graphHopper;

        HasElevation() {
        }

        @Override
        public Boolean provide() {
            return this.graphHopper.hasElevation();
        }

        @Override
        public void dispose(Boolean instance) {
        }
    }

    static class PathDetailsBuilderFactoryFactory
    implements Factory<PathDetailsBuilderFactory> {
        @Inject
        GraphHopper graphHopper;

        PathDetailsBuilderFactoryFactory() {
        }

        @Override
        public PathDetailsBuilderFactory provide() {
            return this.graphHopper.getPathDetailsBuilderFactory();
        }

        @Override
        public void dispose(PathDetailsBuilderFactory profileResolver) {
        }
    }

    static class ProfileResolverFactory
    implements Factory<ProfileResolver> {
        @Inject
        GraphHopper graphHopper;

        ProfileResolverFactory() {
        }

        @Override
        public ProfileResolver provide() {
            return new ProfileResolver(this.graphHopper.getEncodingManager(), this.graphHopper.getProfiles(), this.graphHopper.getCHPreparationHandler().getCHProfiles(), this.graphHopper.getLMPreparationHandler().getLMProfiles());
        }

        @Override
        public void dispose(ProfileResolver profileResolver) {
        }
    }

    static class LocationIndexFactory
    implements Factory<LocationIndex> {
        @Inject
        GraphHopper graphHopper;

        LocationIndexFactory() {
        }

        @Override
        public LocationIndex provide() {
            return this.graphHopper.getLocationIndex();
        }

        @Override
        public void dispose(LocationIndex instance) {
        }
    }

    static class EncodingManagerFactory
    implements Factory<EncodingManager> {
        @Inject
        GraphHopper graphHopper;

        EncodingManagerFactory() {
        }

        @Override
        public EncodingManager provide() {
            return this.graphHopper.getEncodingManager();
        }

        @Override
        public void dispose(EncodingManager instance) {
        }
    }

    static class GtfsStorageFactory
    implements Factory<GtfsStorage> {
        @Inject
        GraphHopperGtfs graphHopper;

        GtfsStorageFactory() {
        }

        @Override
        public GtfsStorage provide() {
            return this.graphHopper.getGtfsStorage();
        }

        @Override
        public void dispose(GtfsStorage instance) {
        }
    }

    static class GraphHopperStorageFactory
    implements Factory<GraphHopperStorage> {
        @Inject
        GraphHopper graphHopper;

        GraphHopperStorageFactory() {
        }

        @Override
        public GraphHopperStorage provide() {
            return this.graphHopper.getGraphHopperStorage();
        }

        @Override
        public void dispose(GraphHopperStorage instance) {
        }
    }

    static class TranslationMapFactory
    implements Factory<TranslationMap> {
        @Inject
        GraphHopper graphHopper;

        TranslationMapFactory() {
        }

        @Override
        public TranslationMap provide() {
            return this.graphHopper.getTranslationMap();
        }

        @Override
        public void dispose(TranslationMap instance) {
        }
    }
}

