/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs;

import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntIntHashMap;
import com.carrotsearch.hppc.IntLongHashMap;
import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Fare;
import com.conveyal.gtfs.model.Frequency;
import com.conveyal.gtfs.model.StopTime;
import com.conveyal.gtfs.model.Trip;
import com.google.transit.realtime.GtfsRealtime;
import com.graphhopper.gtfs.GtfsReader;
import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.GtfsStorageI;
import com.graphhopper.gtfs.Label;
import com.graphhopper.gtfs.Transfers;
import com.graphhopper.routing.querygraph.VirtualEdgeIteratorState;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.BBox;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.mapdb.Fun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealtimeFeed {
    private static final Logger logger = LoggerFactory.getLogger(RealtimeFeed.class);
    private final IntHashSet blockedEdges;
    private final IntLongHashMap delaysForBoardEdges;
    private final IntLongHashMap delaysForAlightEdges;
    private final List<VirtualEdgeIteratorState> additionalEdges;
    public final Map<String, GtfsRealtime.FeedMessage> feedMessages;
    private final GtfsStorage staticGtfs;
    private final Map<Integer, byte[]> additionalTripDescriptors;
    private final Map<Integer, Integer> stopSequences;
    private final Map<Integer, GtfsStorage.Validity> validities;
    private final Map<Integer, GtfsStorageI.PlatformDescriptor> platformDescriptorByEdge;

    private RealtimeFeed(GtfsStorage staticGtfs, Map<String, GtfsRealtime.FeedMessage> feedMessages, IntHashSet blockedEdges, IntLongHashMap delaysForBoardEdges, IntLongHashMap delaysForAlightEdges, List<VirtualEdgeIteratorState> additionalEdges, Map<Integer, byte[]> tripDescriptors, Map<Integer, Integer> stopSequences, Map<GtfsStorage.Validity, Integer> operatingDayPatterns, Map<GtfsStorage.FeedIdWithTimezone, Integer> writableTimeZones, Map<Integer, GtfsStorageI.PlatformDescriptor> platformDescriptorByEdge) {
        this.staticGtfs = staticGtfs;
        this.feedMessages = feedMessages;
        this.blockedEdges = blockedEdges;
        this.delaysForBoardEdges = delaysForBoardEdges;
        this.delaysForAlightEdges = delaysForAlightEdges;
        this.additionalEdges = additionalEdges;
        this.additionalTripDescriptors = tripDescriptors;
        this.stopSequences = stopSequences;
        HashMap<Integer, GtfsStorage.Validity> reverseOperatingDayPatterns = new HashMap<Integer, GtfsStorage.Validity>();
        for (Map.Entry<GtfsStorage.Validity, Integer> entry : operatingDayPatterns.entrySet()) {
            reverseOperatingDayPatterns.put(entry.getValue(), entry.getKey());
        }
        this.validities = Collections.unmodifiableMap(reverseOperatingDayPatterns);
        this.platformDescriptorByEdge = platformDescriptorByEdge;
    }

    public static RealtimeFeed empty(GtfsStorage staticGtfs) {
        return new RealtimeFeed(staticGtfs, Collections.emptyMap(), new IntHashSet(), new IntLongHashMap(), new IntLongHashMap(), Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), staticGtfs.getOperatingDayPatterns(), staticGtfs.getWritableTimeZones(), staticGtfs.getPlatformDescriptorByEdge());
    }

    public static RealtimeFeed fromProtobuf(final GraphHopperStorage graphHopperStorage, final GtfsStorage staticGtfs, Map<String, Transfers> transfers, Map<String, GtfsRealtime.FeedMessage> feedMessages) {
        IntHashSet blockedEdges = new IntHashSet();
        IntLongHashMap delaysForBoardEdges = new IntLongHashMap();
        IntLongHashMap delaysForAlightEdges = new IntLongHashMap();
        final LinkedList<VirtualEdgeIteratorState> additionalEdges = new LinkedList<VirtualEdgeIteratorState>();
        Graph overlayGraph = new Graph(){
            int firstEdge;
            EncodingManager encodingManager;
            final NodeAccess nodeAccess;
            {
                this.firstEdge = graphHopperStorage.getEdges();
                this.encodingManager = graphHopperStorage.getEncodingManager();
                this.nodeAccess = new NodeAccess(){
                    IntIntHashMap turnCostIndices = new IntIntHashMap();

                    @Override
                    public int getTurnCostIndex(int nodeId) {
                        return 0;
                    }

                    @Override
                    public void setTurnCostIndex(int nodeId, int additionalValue) {
                        this.turnCostIndices.put(nodeId, additionalValue);
                    }

                    @Override
                    public boolean is3D() {
                        return false;
                    }

                    @Override
                    public int getDimension() {
                        return 0;
                    }

                    @Override
                    public void ensureNode(int nodeId) {
                    }

                    @Override
                    public void setNode(int nodeId, double lat, double lon) {
                    }

                    @Override
                    public void setNode(int nodeId, double lat, double lon, double ele) {
                    }

                    @Override
                    public double getLatitude(int nodeId) {
                        return 0.0;
                    }

                    @Override
                    public double getLat(int nodeId) {
                        return 0.0;
                    }

                    @Override
                    public double getLongitude(int nodeId) {
                        return 0.0;
                    }

                    @Override
                    public double getLon(int nodeId) {
                        return 0.0;
                    }

                    @Override
                    public double getElevation(int nodeId) {
                        return 0.0;
                    }

                    @Override
                    public double getEle(int nodeId) {
                        return 0.0;
                    }
                };
            }

            @Override
            public Graph getBaseGraph() {
                return graphHopperStorage;
            }

            @Override
            public int getNodes() {
                return IntStream.concat(IntStream.of(graphHopperStorage.getNodes() - 1), additionalEdges.stream().flatMapToInt(edge -> IntStream.of(edge.getBaseNode(), edge.getAdjNode()))).max().getAsInt() + 1;
            }

            @Override
            public int getEdges() {
                return this.getAllEdges().length();
            }

            @Override
            public NodeAccess getNodeAccess() {
                return this.nodeAccess;
            }

            @Override
            public BBox getBounds() {
                return null;
            }

            @Override
            public EdgeIteratorState edge(int a, int b) {
                int edge = this.firstEdge++;
                VirtualEdgeIteratorState newEdge = new VirtualEdgeIteratorState(-1, edge, a, b, 0.0, this.encodingManager.createEdgeFlags(), "", new PointList(), false);
                VirtualEdgeIteratorState reverseNewEdge = new VirtualEdgeIteratorState(-1, edge, b, a, 0.0, this.encodingManager.createEdgeFlags(), "", new PointList(), true);
                newEdge.setReverseEdge(reverseNewEdge);
                reverseNewEdge.setReverseEdge(newEdge);
                additionalEdges.push(newEdge);
                return newEdge;
            }

            @Override
            public EdgeIteratorState edge(int a, int b, double distance, boolean bothDirections) {
                return null;
            }

            @Override
            public EdgeIteratorState getEdgeIteratorState(int edgeId, int adjNode) {
                return null;
            }

            @Override
            public AllEdgesIterator getAllEdges() {
                return null;
            }

            @Override
            public EdgeExplorer createEdgeExplorer(EdgeFilter filter) {
                return null;
            }

            @Override
            public Graph copyTo(Graph g2) {
                return null;
            }

            @Override
            public TurnCostStorage getTurnCostStorage() {
                throw new RuntimeException();
            }

            @Override
            public Weighting wrapWeighting(Weighting weighting) {
                throw new RuntimeException();
            }

            @Override
            public int getOtherNode(int edge, int node) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isAdjacentToNode(int edge, int node) {
                throw new UnsupportedOperationException();
            }
        };
        final HashMap<GtfsStorage.Validity, Integer> operatingDayPatterns = new HashMap<GtfsStorage.Validity, Integer>(staticGtfs.getOperatingDayPatterns());
        final HashMap<Integer, byte[]> tripDescriptors = new HashMap<Integer, byte[]>();
        final HashMap<Integer, Integer> stopSequences = new HashMap<Integer, Integer>();
        final HashMap boardEdgesForTrip = new HashMap();
        final HashMap alightEdgesForTrip = new HashMap();
        final HashMap<GtfsStorage.FeedIdWithTimezone, Integer> writableTimeZones = new HashMap<GtfsStorage.FeedIdWithTimezone, Integer>(staticGtfs.getWritableTimeZones());
        HashMap<Integer, GtfsStorageI.PlatformDescriptor> platformDescriptorByEdge = new HashMap<Integer, GtfsStorageI.PlatformDescriptor>(staticGtfs.getPlatformDescriptorByEdge());
        feedMessages.forEach((feedKey, feedMessage) -> {
            GTFSFeed feed = staticGtfs.getGtfsFeeds().get(feedKey);
            ZoneId timezone = ZoneId.of(feed.agency.values().stream().findFirst().get().agency_timezone);
            GtfsStorageI gtfsStorage = new GtfsStorageI((String)feedKey, feed, platformDescriptorByEdge){
                final /* synthetic */ String val$feedKey;
                final /* synthetic */ GTFSFeed val$feed;
                final /* synthetic */ Map val$platformDescriptorByEdge;
                {
                    this.val$feedKey = string;
                    this.val$feed = gTFSFeed;
                    this.val$platformDescriptorByEdge = map7;
                }

                @Override
                public Map<String, Fare> getFares() {
                    return null;
                }

                @Override
                public Map<GtfsStorage.Validity, Integer> getOperatingDayPatterns() {
                    return operatingDayPatterns;
                }

                @Override
                public Map<GtfsStorage.FeedIdWithTimezone, Integer> getWritableTimeZones() {
                    return writableTimeZones;
                }

                @Override
                public Map<Integer, GtfsStorage.FeedIdWithTimezone> getTimeZones() {
                    return staticGtfs.getTimeZones();
                }

                @Override
                public Map<Integer, byte[]> getTripDescriptors() {
                    return tripDescriptors;
                }

                @Override
                public Map<Integer, Integer> getStopSequences() {
                    return stopSequences;
                }

                @Override
                public Map<String, int[]> getBoardEdgesForTrip() {
                    return boardEdgesForTrip;
                }

                @Override
                public Map<String, int[]> getAlightEdgesForTrip() {
                    return alightEdgesForTrip;
                }

                @Override
                public Map<String, GTFSFeed> getGtfsFeeds() {
                    HashMap<String, GTFSFeed> stringGTFSFeedHashMap = new HashMap<String, GTFSFeed>();
                    stringGTFSFeedHashMap.put(this.val$feedKey, this.val$feed);
                    return stringGTFSFeedHashMap;
                }

                @Override
                public Map<GtfsStorage.FeedIdWithStopId, Integer> getStationNodes() {
                    return staticGtfs.getStationNodes();
                }

                @Override
                public Map<Integer, GtfsStorageI.PlatformDescriptor> getPlatformDescriptorByEdge() {
                    return this.val$platformDescriptorByEdge;
                }
            };
            GtfsReader gtfsReader = new GtfsReader((String)feedKey, overlayGraph, graphHopperStorage.getEncodingManager(), gtfsStorage, null, (Transfers)transfers.get(feedKey));
            Instant timestamp = Instant.ofEpochSecond(feedMessage.getHeader().getTimestamp());
            LocalDate dateToChange = timestamp.atZone(timezone).toLocalDate();
            BitSet validOnDay = new BitSet();
            LocalDate startDate = feed.getStartDate();
            validOnDay.set((int)ChronoUnit.DAYS.between(startDate, dateToChange));
            feedMessage.getEntityList().stream().filter(GtfsRealtime.FeedEntity::hasTripUpdate).map(GtfsRealtime.FeedEntity::getTripUpdate).filter(tripUpdate -> tripUpdate.getTrip().getScheduleRelationship() == GtfsRealtime.TripDescriptor.ScheduleRelationship.SCHEDULED).forEach(tripUpdate -> {
                Collection<Frequency> frequencies = feed.getFrequencies(tripUpdate.getTrip().getTripId());
                int timeOffset = tripUpdate.getTrip().hasStartTime() && !frequencies.isEmpty() ? LocalTime.parse(tripUpdate.getTrip().getStartTime()).toSecondOfDay() : 0;
                String key = GtfsStorage.tripKey(tripUpdate.getTrip(), !frequencies.isEmpty());
                int[] boardEdges = staticGtfs.getBoardEdgesForTrip().get(key);
                int[] leaveEdges = staticGtfs.getAlightEdgesForTrip().get(key);
                if (boardEdges == null || leaveEdges == null) {
                    logger.warn("Trip not found: {}", (Object)tripUpdate.getTrip());
                    return;
                }
                tripUpdate.getStopTimeUpdateList().stream().filter(stopTimeUpdate -> stopTimeUpdate.getScheduleRelationship() == GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship.SKIPPED).mapToInt(GtfsRealtime.TripUpdate.StopTimeUpdate::getStopSequence).forEach(skippedStopSequenceNumber -> {
                    blockedEdges.add(boardEdges[skippedStopSequenceNumber]);
                    blockedEdges.add(leaveEdges[skippedStopSequenceNumber]);
                });
                GtfsReader.TripWithStopTimes tripWithStopTimes = RealtimeFeed.toTripWithStopTimes(feed, tripUpdate);
                tripWithStopTimes.stopTimes.forEach(stopTime -> {
                    if (stopTime.stop_sequence > leaveEdges.length - 1) {
                        logger.warn("Stop sequence number too high {} vs {}", (Object)stopTime.stop_sequence, (Object)leaveEdges.length);
                        return;
                    }
                    StopTime originalStopTime = feed.stop_times.get(new Fun.Tuple2<String, Integer>(tripUpdate.getTrip().getTripId(), stopTime.stop_sequence));
                    int arrivalDelay = stopTime.arrival_time - originalStopTime.arrival_time;
                    delaysForAlightEdges.put(leaveEdges[stopTime.stop_sequence], arrivalDelay * 1000);
                    int departureDelay = stopTime.departure_time - originalStopTime.departure_time;
                    if (departureDelay > 0) {
                        int boardEdge = boardEdges[stopTime.stop_sequence];
                        int departureNode = graphHopperStorage.getEdgeIteratorState(boardEdge, Integer.MIN_VALUE).getAdjNode();
                        int delayedBoardEdge = gtfsReader.addDelayedBoardEdge(timezone, tripUpdate.getTrip(), stopTime.stop_sequence, stopTime.departure_time + timeOffset, departureNode, validOnDay);
                        delaysForBoardEdges.put(delayedBoardEdge, departureDelay * 1000);
                    }
                });
            });
            feedMessage.getEntityList().stream().filter(GtfsRealtime.FeedEntity::hasTripUpdate).map(GtfsRealtime.FeedEntity::getTripUpdate).filter(tripUpdate -> tripUpdate.getTrip().getScheduleRelationship() == GtfsRealtime.TripDescriptor.ScheduleRelationship.ADDED).forEach(tripUpdate -> {
                Trip trip = new Trip();
                trip.trip_id = tripUpdate.getTrip().getTripId();
                trip.route_id = tripUpdate.getTrip().getRouteId();
                List<StopTime> stopTimes = tripUpdate.getStopTimeUpdateList().stream().map(stopTimeUpdate -> {
                    StopTime stopTime = new StopTime();
                    stopTime.stop_sequence = stopTimeUpdate.getStopSequence();
                    stopTime.stop_id = stopTimeUpdate.getStopId();
                    stopTime.trip_id = trip.trip_id;
                    ZonedDateTime arrival_time = Instant.ofEpochSecond(stopTimeUpdate.getArrival().getTime()).atZone(timezone);
                    stopTime.arrival_time = (int)Duration.between(arrival_time.truncatedTo(ChronoUnit.DAYS), arrival_time).getSeconds();
                    ZonedDateTime departure_time = Instant.ofEpochSecond(stopTimeUpdate.getArrival().getTime()).atZone(timezone);
                    stopTime.departure_time = (int)Duration.between(departure_time.truncatedTo(ChronoUnit.DAYS), departure_time).getSeconds();
                    return stopTime;
                }).collect(Collectors.toList());
                GtfsReader.TripWithStopTimes tripWithStopTimes = new GtfsReader.TripWithStopTimes(trip, stopTimes, validOnDay, Collections.emptySet(), Collections.emptySet());
                gtfsReader.addTrip(timezone, 0, new ArrayList<GtfsReader.TripWithStopTimeAndArrivalNode>(), tripWithStopTimes, tripUpdate.getTrip(), false);
            });
            gtfsReader.wireUpAdditionalDeparturesAndArrivals(timezone);
        });
        return new RealtimeFeed(staticGtfs, feedMessages, blockedEdges, delaysForBoardEdges, delaysForAlightEdges, additionalEdges, tripDescriptors, stopSequences, operatingDayPatterns, writableTimeZones, platformDescriptorByEdge);
    }

    boolean isBlocked(int edgeId) {
        return this.blockedEdges.contains(edgeId);
    }

    List<VirtualEdgeIteratorState> getAdditionalEdges() {
        return this.additionalEdges;
    }

    public Optional<GtfsReader.TripWithStopTimes> getTripUpdate(GTFSFeed staticFeed, GtfsRealtime.TripDescriptor tripDescriptor, Label.Transition boardEdge, Instant boardTime) {
        try {
            logger.trace("getTripUpdate {}", (Object)tripDescriptor);
            if (!this.isThisRealtimeUpdateAboutThisLineRun(boardEdge.edge.edgeIteratorState, boardTime)) {
                return Optional.empty();
            }
            GtfsRealtime.TripDescriptor normalizedTripDescriptor = this.normalize(tripDescriptor);
            return this.feedMessages.values().stream().flatMap(feedMessage -> feedMessage.getEntityList().stream().filter(e -> e.hasTripUpdate()).map(e -> e.getTripUpdate()).filter(tu -> this.normalize(tu.getTrip()).equals(normalizedTripDescriptor)).map(tu -> RealtimeFeed.toTripWithStopTimes(staticFeed, tu))).findFirst();
        }
        catch (RuntimeException e) {
            this.feedMessages.forEach((name, feed) -> {
                try (FileOutputStream s2 = new FileOutputStream(name + ".gtfsdump");){
                    feed.writeTo(s2);
                }
                catch (IOException e1) {
                    throw new RuntimeException();
                }
            });
            return Optional.empty();
        }
    }

    public GtfsRealtime.TripDescriptor normalize(GtfsRealtime.TripDescriptor tripDescriptor) {
        return GtfsRealtime.TripDescriptor.newBuilder(tripDescriptor).clearRouteId().build();
    }

    public static GtfsReader.TripWithStopTimes toTripWithStopTimes(GTFSFeed feed, GtfsRealtime.TripUpdate tripUpdate) {
        Iterable<StopTime> interpolatedStopTimesForTrip;
        ZoneId timezone = ZoneId.of(feed.agency.values().stream().findFirst().get().agency_timezone);
        logger.trace("{}", (Object)tripUpdate.getTrip());
        ArrayList<StopTime> stopTimes = new ArrayList<StopTime>();
        HashSet<Integer> cancelledArrivals = new HashSet<Integer>();
        HashSet<Integer> cancelledDepartures = new HashSet<Integer>();
        Trip originalTrip = feed.trips.get(tripUpdate.getTrip().getTripId());
        Trip trip = new Trip();
        if (originalTrip != null) {
            trip.trip_id = originalTrip.trip_id;
            trip.route_id = originalTrip.route_id;
        } else {
            trip.trip_id = tripUpdate.getTrip().getTripId();
            trip.route_id = tripUpdate.getTrip().getRouteId();
        }
        int delay = 0;
        int time = -1;
        ArrayList<GtfsRealtime.TripUpdate.StopTimeUpdate> stopTimeUpdateListWithSentinel = new ArrayList<GtfsRealtime.TripUpdate.StopTimeUpdate>(tripUpdate.getStopTimeUpdateList());
        try {
            interpolatedStopTimesForTrip = feed.getInterpolatedStopTimesForTrip(tripUpdate.getTrip().getTripId());
        }
        catch (GTFSFeed.FirstAndLastStopsDoNotHaveTimes firstAndLastStopsDoNotHaveTimes) {
            throw new RuntimeException(firstAndLastStopsDoNotHaveTimes);
        }
        int stopSequenceCeiling = Math.max(stopTimeUpdateListWithSentinel.isEmpty() ? 0 : ((GtfsRealtime.TripUpdate.StopTimeUpdate)stopTimeUpdateListWithSentinel.get(stopTimeUpdateListWithSentinel.size() - 1)).getStopSequence(), StreamSupport.stream(interpolatedStopTimesForTrip.spliterator(), false).mapToInt(stopTime -> stopTime.stop_sequence).max().orElse(0)) + 1;
        stopTimeUpdateListWithSentinel.add(GtfsRealtime.TripUpdate.StopTimeUpdate.newBuilder().setStopSequence(stopSequenceCeiling).setScheduleRelationship(GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship.NO_DATA).build());
        for (GtfsRealtime.TripUpdate.StopTimeUpdate stopTimeUpdate : stopTimeUpdateListWithSentinel) {
            int nextStopSequence;
            for (int i = nextStopSequence = stopTimes.isEmpty() ? 1 : ((StopTime)stopTimes.get((int)(stopTimes.size() - 1))).stop_sequence + 1; i < stopTimeUpdate.getStopSequence(); ++i) {
                StopTime previousOriginalStopTime = feed.stop_times.get(new Fun.Tuple2<String, Integer>(tripUpdate.getTrip().getTripId(), i));
                if (previousOriginalStopTime == null) continue;
                StopTime updatedPreviousStopTime = previousOriginalStopTime.clone();
                updatedPreviousStopTime.arrival_time = Math.max(previousOriginalStopTime.arrival_time + delay, time);
                logger.trace("stop_sequence {} scheduled arrival {} updated arrival {}", i, previousOriginalStopTime.arrival_time, updatedPreviousStopTime.arrival_time);
                time = updatedPreviousStopTime.arrival_time;
                updatedPreviousStopTime.departure_time = Math.max(previousOriginalStopTime.departure_time + delay, time);
                logger.trace("stop_sequence {} scheduled departure {} updated departure {}", i, previousOriginalStopTime.departure_time, updatedPreviousStopTime.departure_time);
                time = updatedPreviousStopTime.departure_time;
                stopTimes.add(updatedPreviousStopTime);
                logger.trace("Number of stop times: {}", (Object)stopTimes.size());
            }
            StopTime originalStopTime = feed.stop_times.get(new Fun.Tuple2<String, Integer>(tripUpdate.getTrip().getTripId(), stopTimeUpdate.getStopSequence()));
            if (originalStopTime != null) {
                StopTime updatedStopTime = originalStopTime.clone();
                if (stopTimeUpdate.getScheduleRelationship() == GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship.NO_DATA) {
                    delay = 0;
                }
                if (stopTimeUpdate.hasArrival()) {
                    delay = stopTimeUpdate.getArrival().getDelay();
                }
                updatedStopTime.arrival_time = Math.max(originalStopTime.arrival_time + delay, time);
                logger.trace("stop_sequence {} scheduled arrival {} updated arrival {}", stopTimeUpdate.getStopSequence(), originalStopTime.arrival_time, updatedStopTime.arrival_time);
                time = updatedStopTime.arrival_time;
                if (stopTimeUpdate.hasDeparture()) {
                    delay = stopTimeUpdate.getDeparture().getDelay();
                }
                updatedStopTime.departure_time = Math.max(originalStopTime.departure_time + delay, time);
                logger.trace("stop_sequence {} scheduled departure {} updated departure {}", stopTimeUpdate.getStopSequence(), originalStopTime.departure_time, updatedStopTime.departure_time);
                time = updatedStopTime.departure_time;
                stopTimes.add(updatedStopTime);
                logger.trace("Number of stop times: {}", (Object)stopTimes.size());
                if (stopTimeUpdate.getScheduleRelationship() != GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship.SKIPPED) continue;
                cancelledArrivals.add(stopTimeUpdate.getStopSequence());
                cancelledDepartures.add(stopTimeUpdate.getStopSequence());
                continue;
            }
            if (stopTimeUpdate.getScheduleRelationship() == GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship.NO_DATA) continue;
            if (tripUpdate.getTrip().getScheduleRelationship() == GtfsRealtime.TripDescriptor.ScheduleRelationship.ADDED) {
                StopTime stopTime2 = new StopTime();
                stopTime2.stop_sequence = stopTimeUpdate.getStopSequence();
                stopTime2.stop_id = stopTimeUpdate.getStopId();
                stopTime2.trip_id = trip.trip_id;
                ZonedDateTime arrival_time = Instant.ofEpochSecond(stopTimeUpdate.getArrival().getTime()).atZone(timezone);
                stopTime2.arrival_time = (int)Duration.between(arrival_time.truncatedTo(ChronoUnit.DAYS), arrival_time).getSeconds();
                ZonedDateTime departure_time = Instant.ofEpochSecond(stopTimeUpdate.getArrival().getTime()).atZone(timezone);
                stopTime2.departure_time = (int)Duration.between(departure_time.truncatedTo(ChronoUnit.DAYS), departure_time).getSeconds();
                stopTimes.add(stopTime2);
                logger.trace("Number of stop times: {}", (Object)stopTimes.size());
                continue;
            }
            throw new RuntimeException();
        }
        logger.trace("Number of stop times: {}", (Object)stopTimes.size());
        BitSet validOnDay = new BitSet();
        return new GtfsReader.TripWithStopTimes(trip, stopTimes, validOnDay, cancelledArrivals, cancelledDepartures);
    }

    public long getDelayForBoardEdge(EdgeIteratorState edge, Instant now) {
        if (this.isThisRealtimeUpdateAboutThisLineRun(edge, now)) {
            return this.delaysForBoardEdges.getOrDefault(edge.getEdge(), 0L);
        }
        return 0L;
    }

    public long getDelayForAlightEdge(EdgeIteratorState edge, Instant now) {
        if (this.isThisRealtimeUpdateAboutThisLineRun(edge, now)) {
            return this.delaysForAlightEdges.getOrDefault(edge.getEdge(), 0L);
        }
        return 0L;
    }

    boolean isThisRealtimeUpdateAboutThisLineRun(EdgeIteratorState edge, Instant now) {
        return Duration.between(this.feedTimestampOrNow(), now).toHours() <= 24L;
    }

    private Instant feedTimestampOrNow() {
        return this.feedMessages.values().stream().map(feedMessage -> {
            if (feedMessage.getHeader().hasTimestamp()) {
                return Instant.ofEpochSecond(feedMessage.getHeader().getTimestamp());
            }
            return Instant.now();
        }).findFirst().orElse(Instant.now());
    }

    public byte[] getTripDescriptor(int edge) {
        return this.staticGtfs.getTripDescriptors().getOrDefault(edge, this.additionalTripDescriptors.get(edge));
    }

    public int getStopSequence(int edge) {
        return this.staticGtfs.getStopSequences().getOrDefault(edge, this.stopSequences.get(edge));
    }

    public StopTime getStopTime(GTFSFeed staticFeed, GtfsRealtime.TripDescriptor tripDescriptor, Label.Transition t, Instant boardTime, int stopSequence) {
        StopTime stopTime = staticFeed.stop_times.get(new Fun.Tuple2<String, Integer>(tripDescriptor.getTripId(), stopSequence));
        if (stopTime == null) {
            return this.getTripUpdate((GTFSFeed)staticFeed, (GtfsRealtime.TripDescriptor)tripDescriptor, (Label.Transition)t, (Instant)boardTime).get().stopTimes.get(stopSequence - 1);
        }
        return stopTime;
    }

    public GtfsStorage.Validity getValidity(int validityId) {
        return this.validities.get(validityId);
    }

    public Map<Integer, GtfsStorageI.PlatformDescriptor> getPlatformDescriptorByEdge() {
        return this.platformDescriptorByEdge;
    }
}

