/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.jersey2;

import com.codahale.metrics.Clock;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.jersey2.InstrumentedResourceMethodApplicationListener;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;

public class MetricsFeature
implements Feature {
    private final MetricRegistry registry;
    private final Clock clock;
    private final boolean trackFilters;

    public MetricsFeature(MetricRegistry registry) {
        this(registry, Clock.defaultClock());
    }

    public MetricsFeature(MetricRegistry registry, Clock clock) {
        this(registry, clock, false);
    }

    public MetricsFeature(MetricRegistry registry, Clock clock, boolean trackFilters) {
        this.registry = registry;
        this.clock = clock;
        this.trackFilters = trackFilters;
    }

    public MetricsFeature(String registryName) {
        this(SharedMetricRegistries.getOrCreate(registryName));
    }

    @Override
    public boolean configure(FeatureContext context) {
        context.register(new InstrumentedResourceMethodApplicationListener(this.registry, this.clock, this.trackFilters));
        return true;
    }
}

