/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.details;

import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.details.AbstractPathDetailsBuilder;

public class TimeDetails
extends AbstractPathDetailsBuilder {
    private final Weighting weighting;
    private int prevEdgeId = -1;
    private long time = 0L;

    public TimeDetails(Weighting weighting) {
        super("time");
        this.weighting = weighting;
    }

    @Override
    public boolean isEdgeDifferentToLastEdge(EdgeIteratorState edge) {
        if (edge.getEdge() != this.prevEdgeId) {
            this.time = GHUtility.calcMillisWithTurnMillis(this.weighting, edge, false, this.prevEdgeId);
            this.prevEdgeId = edge.getEdge();
            return true;
        }
        return false;
    }

    @Override
    public Object getCurrentValue() {
        return this.time;
    }
}

