/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.Helper;

class GHNodeAccess
implements NodeAccess {
    private final BaseGraph baseGraph;
    private final boolean elevation;

    public GHNodeAccess(BaseGraph baseGraph, boolean withElevation) {
        this.baseGraph = baseGraph;
        this.elevation = withElevation;
    }

    public void ensureNode(int nodeId) {
        this.baseGraph.ensureNodeIndex(nodeId);
    }

    public final void setNode(int nodeId, double lat, double lon) {
        this.setNode(nodeId, lat, lon, Double.NaN);
    }

    public final void setNode(int nodeId, double lat, double lon, double ele) {
        this.baseGraph.ensureNodeIndex(nodeId);
        long tmp = (long)nodeId * (long)this.baseGraph.nodeEntryBytes;
        this.baseGraph.nodes.setInt(tmp + (long)this.baseGraph.N_LAT, Helper.degreeToInt((double)lat));
        this.baseGraph.nodes.setInt(tmp + (long)this.baseGraph.N_LON, Helper.degreeToInt((double)lon));
        if (this.is3D()) {
            this.baseGraph.nodes.setInt(tmp + (long)this.baseGraph.N_ELE, Helper.eleToInt((double)ele));
            this.baseGraph.bounds.update(lat, lon, ele);
        } else {
            this.baseGraph.bounds.update(lat, lon);
        }
    }

    public final double getLatitude(int nodeId) {
        return Helper.intToDegree((int)this.baseGraph.nodes.getInt((long)nodeId * (long)this.baseGraph.nodeEntryBytes + (long)this.baseGraph.N_LAT));
    }

    public final double getLongitude(int nodeId) {
        return Helper.intToDegree((int)this.baseGraph.nodes.getInt((long)nodeId * (long)this.baseGraph.nodeEntryBytes + (long)this.baseGraph.N_LON));
    }

    public final double getElevation(int nodeId) {
        if (!this.elevation) {
            throw new IllegalStateException("Cannot access elevation - 3D is not enabled");
        }
        return Helper.intToEle((int)this.baseGraph.nodes.getInt((long)nodeId * (long)this.baseGraph.nodeEntryBytes + (long)this.baseGraph.N_ELE));
    }

    public final double getEle(int nodeId) {
        return this.getElevation(nodeId);
    }

    public final double getLat(int nodeId) {
        return this.getLatitude(nodeId);
    }

    public final double getLon(int nodeId) {
        return this.getLongitude(nodeId);
    }

    @Override
    public final void setTurnCostIndex(int index, int turnCostIndex) {
        if (!this.baseGraph.supportsTurnCosts()) {
            throw new AssertionError((Object)"This graph does not support turn costs");
        }
        this.baseGraph.ensureNodeIndex(index);
        long tmp = (long)index * (long)this.baseGraph.nodeEntryBytes;
        this.baseGraph.nodes.setInt(tmp + (long)this.baseGraph.N_TC, turnCostIndex);
    }

    @Override
    public final int getTurnCostIndex(int index) {
        if (this.baseGraph.supportsTurnCosts()) {
            return this.baseGraph.nodes.getInt((long)index * (long)this.baseGraph.nodeEntryBytes + (long)this.baseGraph.N_TC);
        }
        throw new AssertionError((Object)"This graph does not support turn costs");
    }

    public final boolean is3D() {
        return this.elevation;
    }

    public int getDimension() {
        if (this.elevation) {
            return 3;
        }
        return 2;
    }
}

